/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.parser;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class Source {
    private static final Comparator<String> LENGTH_DESC_COMPARATOR = Comparator.comparing(String::length).reversed();
    private final String raw;
    private final int from;
    private final int to;

    public Source(String raw) {
        this(raw, 0, raw.length());
    }

    private Source(String raw, int from, int to) {
        this.raw = raw;
        this.from = from;
        this.to = to;
    }

    public boolean isEmpty() {
        return this.from == this.to;
    }

    public int length() {
        return this.to - this.from;
    }

    public int indexOf(String str) {
        int index = this.raw.indexOf(str, this.from);
        if (index == -1 || index + str.length() > this.to) {
            return -1;
        }
        return index - this.from;
    }

    public Source trimStart(String str) {
        int len = str.length();
        if (this.from + len > this.to) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            if (this.raw.charAt(this.from + i) == str.charAt(i)) continue;
            return null;
        }
        return new Source(this.raw, this.from + len, this.to);
    }

    public Source trimStart(String ... arr) {
        List<String> list = Arrays.asList(arr);
        list.sort(LENGTH_DESC_COMPARATOR);
        for (String str : list) {
            Source rest = this.trimStart(str);
            if (rest == null) continue;
            return rest;
        }
        return null;
    }

    public Source trimEnd(String str) {
        int len = str.length();
        int from = this.to - len;
        if (from < this.from) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            if (this.raw.charAt(from + i) == str.charAt(i)) continue;
            return null;
        }
        return new Source(this.raw, this.from, this.to - len);
    }

    public Source trimEnd(String ... arr) {
        List<String> list = Arrays.asList(arr);
        list.sort(LENGTH_DESC_COMPARATOR);
        for (String str : list) {
            Source rest = this.trimEnd(str);
            if (rest == null) continue;
            return rest;
        }
        return null;
    }

    public Source subSource(int from) {
        return this.subSource(from, this.to - this.from);
    }

    public Source subSource(int from, int to) {
        int len = this.to - this.from;
        if (from > to || from < 0 || to > len) {
            throw new IllegalArgumentException("Illegal from and to");
        }
        if (from == 0 && to == len) {
            return this;
        }
        return new Source(this.raw, this.from + from, this.from + to);
    }

    public char charAt(int index) {
        if (index < 0 || index > this.to - this.from) {
            throw new IndexOutOfBoundsException();
        }
        return this.raw.charAt(this.from + index);
    }

    public String asString() {
        return this.raw.substring(this.from, this.to);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int len = this.raw.length();
        for (int i = 0; i < len; ++i) {
            if (i == this.from) {
                builder.append('[');
            }
            if (i == this.to) {
                builder.append(']');
            }
            builder.append(this.raw.charAt(i));
        }
        if (this.to == len) {
            builder.append(']');
        }
        return builder.toString();
    }
}

