/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.client;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.babyfish.jimmer.client.runtime.Metadata;
import org.babyfish.jimmer.client.runtime.Operation;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class Metadatas {
    private static final Pattern COMMA_PATTERN = Pattern.compile("\\s*,\\s*");

    private Metadatas() {
    }

    public static Metadata create(boolean isGenericSupported, @Nullable String groups) {
        return Metadata.newBuilder().setOperationParser((Metadata.OperationParser)new OperationParserImpl()).setParameterParameter((Metadata.ParameterParser)new ParameterParserImpl()).setGenericSupported(isGenericSupported).setGroups(groups != null && !groups.isEmpty() ? Arrays.asList(COMMA_PATTERN.split(groups)) : null).build();
    }

    private static class OperationParserImpl
    implements Metadata.OperationParser {
        private OperationParserImpl() {
        }

        public String uri(AnnotatedElement element) {
            String uri;
            String uri2;
            String uri3;
            String uri4;
            String uri5;
            RequestMapping requestMapping = element.getAnnotation(RequestMapping.class);
            if (requestMapping != null && (uri5 = OperationParserImpl.uri(requestMapping.value(), requestMapping.path())) != null) {
                return uri5;
            }
            GetMapping getMapping = element.getAnnotation(GetMapping.class);
            if (getMapping != null && (uri4 = OperationParserImpl.uri(getMapping.value(), getMapping.path())) != null) {
                return uri4;
            }
            PostMapping postMapping = element.getAnnotation(PostMapping.class);
            if (postMapping != null && (uri3 = OperationParserImpl.uri(postMapping.value(), postMapping.path())) != null) {
                return uri3;
            }
            PutMapping putMapping = element.getAnnotation(PutMapping.class);
            if (putMapping != null && (uri2 = OperationParserImpl.uri(putMapping.value(), putMapping.path())) != null) {
                return uri2;
            }
            DeleteMapping deleteMapping = element.getAnnotation(DeleteMapping.class);
            if (deleteMapping != null && (uri = OperationParserImpl.uri(deleteMapping.value(), deleteMapping.path())) != null) {
                return uri;
            }
            return null;
        }

        public Operation.HttpMethod[] http(Method method) {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping != null) {
                if (requestMapping.method().length == 0) {
                    return new Operation.HttpMethod[]{Operation.HttpMethod.GET};
                }
                return (Operation.HttpMethod[])Arrays.stream(requestMapping.method()).map(OperationParserImpl::httpMethod).toArray(Operation.HttpMethod[]::new);
            }
            if (method.getAnnotation(PostMapping.class) != null) {
                return new Operation.HttpMethod[]{Operation.HttpMethod.POST};
            }
            if (method.getAnnotation(PutMapping.class) != null) {
                return new Operation.HttpMethod[]{Operation.HttpMethod.PUT};
            }
            if (method.getAnnotation(DeleteMapping.class) != null) {
                return new Operation.HttpMethod[]{Operation.HttpMethod.DELETE};
            }
            return new Operation.HttpMethod[]{Operation.HttpMethod.GET};
        }

        private static String uri(String[] value, String[] path) {
            for (String uri : value) {
                if (uri.isEmpty()) continue;
                return uri;
            }
            for (String uri : path) {
                if (uri.isEmpty()) continue;
                return uri;
            }
            return null;
        }

        private static Operation.HttpMethod httpMethod(RequestMethod method) {
            switch (method) {
                case HEAD: {
                    return Operation.HttpMethod.HEAD;
                }
                case POST: {
                    return Operation.HttpMethod.POST;
                }
                case PUT: {
                    return Operation.HttpMethod.PUT;
                }
                case PATCH: {
                    return Operation.HttpMethod.PATCH;
                }
                case DELETE: {
                    return Operation.HttpMethod.DELETE;
                }
                case OPTIONS: {
                    return Operation.HttpMethod.OPTIONS;
                }
                case TRACE: {
                    return Operation.HttpMethod.TRACE;
                }
            }
            return Operation.HttpMethod.GET;
        }
    }

    private static class ParameterParserImpl
    implements Metadata.ParameterParser {
        private ParameterParserImpl() {
        }

        @Nullable
        public String requestHeader(Parameter javaParameter) {
            RequestHeader requestHeader = javaParameter.getAnnotation(RequestHeader.class);
            if (requestHeader == null) {
                return null;
            }
            String name = requestHeader.value();
            if (name.isEmpty()) {
                name = requestHeader.name();
            }
            return name;
        }

        @Nullable
        public String requestParam(Parameter javaParameter) {
            RequestParam requestParam = javaParameter.getAnnotation(RequestParam.class);
            if (requestParam == null) {
                return null;
            }
            String name = requestParam.value();
            if (name.isEmpty()) {
                name = requestParam.name();
            }
            return name;
        }

        @Nullable
        public String pathVariable(Parameter javaParameter) {
            PathVariable pathVariable = javaParameter.getAnnotation(PathVariable.class);
            if (pathVariable == null) {
                return null;
            }
            String name = pathVariable.value();
            if (name.isEmpty()) {
                name = pathVariable.name();
            }
            return name;
        }

        public String defaultValue(Parameter javaParameter) {
            RequestHeader requestHeader = javaParameter.getAnnotation(RequestHeader.class);
            if (requestHeader != null && !requestHeader.defaultValue().isEmpty() && !requestHeader.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
                return requestHeader.defaultValue();
            }
            RequestParam requestParam = javaParameter.getAnnotation(RequestParam.class);
            if (requestParam != null && !requestParam.defaultValue().isEmpty() && !requestParam.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
                return requestParam.defaultValue();
            }
            return null;
        }

        public boolean isOptional(Parameter javaParameter) {
            RequestParam requestParam = javaParameter.getAnnotation(RequestParam.class);
            if (requestParam != null) {
                return !requestParam.required();
            }
            return false;
        }

        public boolean isRequestBody(Parameter javaParameter) {
            return javaParameter.isAnnotationPresent(RequestBody.class);
        }
    }
}

