/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cloud;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Collection;
import java.util.List;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.MicroServiceExchange;
import org.springframework.web.client.RestTemplate;

public class SpringCloudExchange
implements MicroServiceExchange {
    private final RestTemplate restTemplate;
    private final ObjectMapper mapper;

    public SpringCloudExchange(RestTemplate restTemplate, ObjectMapper mapper) {
        this.restTemplate = restTemplate;
        this.mapper = mapper;
    }

    public List<ImmutableSpi> findByIds(String microServiceName, Collection<?> ids, Fetcher<?> fetcher) throws JsonProcessingException {
        String json = (String)this.restTemplate.getForObject("http://" + microServiceName + "/jimmerMicroServiceBridge/byIds" + "?" + "ids" + "={ids}&" + "fetcher" + "={fetcher}", String.class, new Object[]{this.mapper.writeValueAsString(ids), fetcher.toString()});
        return (List)this.mapper.readValue(json, this.mapper.getTypeFactory().constructParametricType(List.class, new Class[]{fetcher.getImmutableType().getJavaClass()}));
    }

    public List<Tuple2<Object, ImmutableSpi>> findByAssociatedIds(String microServiceName, ImmutableProp prop, Collection<?> targetIds, Fetcher<?> fetcher) throws JsonProcessingException {
        String json = (String)this.restTemplate.getForObject("http://" + microServiceName + "/jimmerMicroServiceBridge/byAssociatedIds" + "?" + "prop" + "={prop}&" + "targetIds" + "={targetIds}&" + "fetcher" + "={fetcher}", String.class, new Object[]{prop.getName(), this.mapper.writeValueAsString(targetIds), fetcher.toString()});
        TypeFactory typeFactory = this.mapper.getTypeFactory();
        return (List)this.mapper.readValue(json, typeFactory.constructParametricType(List.class, new JavaType[]{typeFactory.constructParametricType(Tuple2.class, new Class[]{Classes.boxTypeOf((Class)prop.getTargetType().getIdProp().getElementClass()), fetcher.getImmutableType().getJavaClass()})}));
    }
}

