/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.client;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.babyfish.jimmer.spring.cfg.JimmerProperties;
import org.babyfish.jimmer.spring.client.OpenApiController;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Controller
public class OpenApiUiController {
    private final JimmerProperties properties;

    public OpenApiUiController(JimmerProperties properties) {
        this.properties = properties;
    }

    @GetMapping(value={"${jimmer.client.openapi.ui-path}"})
    public ResponseEntity<StreamingResponseBody> download(@RequestParam(name="groups", required=false) String groups) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "text/html");
        StreamingResponseBody body = out -> {
            OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
            String html = this.html(groups);
            writer.write(html);
            ((Writer)writer).flush();
        };
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)body);
    }

    private String html(String groups) throws IOException {
        String path = this.properties.getClient().getOpenapi().getPath();
        String resource = path != null && !path.isEmpty() ? "META-INF/jimmer/openapi/index.html.template" : "META-INF/jimmer/openapi/on-api.html.template";
        StringBuilder builder = new StringBuilder();
        char[] buf = new char[1024];
        try (InputStreamReader reader = new InputStreamReader(OpenApiController.class.getClassLoader().getResourceAsStream(resource));){
            int len = reader.read(buf);
            if (len != -1) {
                builder.append(buf, 0, len);
            }
        }
        if (path == null || path.isEmpty()) {
            return builder.toString();
        }
        if (groups != null && !groups.isEmpty()) {
            path = path + "?groups=" + URLEncoder.encode(groups, "utf-8");
        }
        return builder.toString().replace("${openapi.path}", path);
    }
}

