/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.parser;

import java.lang.reflect.Method;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.repository.parser.Context;
import org.babyfish.jimmer.spring.repository.parser.Query;
import org.babyfish.jimmer.spring.repository.parser.QueryMethodParser;

public class QueryMethod {
    private final Method javaMethod;
    private final Query query;
    private final Class<?> viewType;
    private final int pageableParamIndex;
    private final int sortParamIndex;
    private final int specificationParamIndex;
    private final int fetcherParamIndex;
    private final int viewTypeParamIndex;

    public QueryMethod(Method javaMethod, Query query, Class<?> viewType, int pageableParamIndex, int sortParamIndex, int specificationParamIndex, int fetcherParamIndex, int viewTypeParamIndex) {
        this.javaMethod = javaMethod;
        this.query = query;
        this.viewType = viewType;
        this.pageableParamIndex = pageableParamIndex;
        this.sortParamIndex = sortParamIndex;
        this.specificationParamIndex = specificationParamIndex;
        this.fetcherParamIndex = fetcherParamIndex;
        this.viewTypeParamIndex = viewTypeParamIndex;
    }

    public static QueryMethod of(Context ctx, ImmutableType type, Method method) {
        return QueryMethodParser.parse(ctx, type, method);
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public Query getQuery() {
        return this.query;
    }

    public Class<?> getViewType() {
        return this.viewType;
    }

    public int getPageableParamIndex() {
        return this.pageableParamIndex;
    }

    public int getSortParamIndex() {
        return this.sortParamIndex;
    }

    public int getSpecificationParamIndex() {
        return this.specificationParamIndex;
    }

    public int getFetcherParamIndex() {
        return this.fetcherParamIndex;
    }

    public int getViewTypeParamIndex() {
        return this.viewTypeParamIndex;
    }

    public String toString() {
        return "QueryMethod{javaMethod=" + this.javaMethod + ", query=" + this.query + ", viewType=" + this.viewType + ", pageableParamIndex=" + this.pageableParamIndex + ", sortParamIndex=" + this.sortParamIndex + ", fetcherParamIndex=" + this.fetcherParamIndex + ", viewTypeParamIndex=" + this.viewTypeParamIndex + '}';
    }
}

