package org.babyfish.jimmer.spring.repository.bytecode;

import org.babyfish.jimmer.impl.asm.Opcodes;

import java.lang.reflect.Method;

public class JavaMethodCodeWriter extends MethodCodeWriter {

    protected JavaMethodCodeWriter(ClassCodeWriter parent, Method method, String id) {
        super(parent, method, id);
    }

    @Override
    protected void visitLoadJSqlClient() {
        mv.visitVarInsn(Opcodes.ALOAD, 0);
        mv.visitMethodInsn(
                Opcodes.INVOKEVIRTUAL,
                parent.getImplInternalName(),
                "sql",
                "()" + J_SQL_CLIENT_DESCRIPTOR,
                false
        );
        mv.visitTypeInsn(
                Opcodes.CHECKCAST,
                J_SQL_CLIENT_IMPLEMENTOR_INTERNAL_NAME
        );
    }
}
