/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg.support;

import java.util.Map;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.TransientResolver;
import org.babyfish.jimmer.sql.runtime.DefaultTransientResolverProvider;
import org.springframework.context.ApplicationContext;

public class SpringTransientResolverProvider
extends DefaultTransientResolverProvider {
    private final ApplicationContext ctx;

    public SpringTransientResolverProvider(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public TransientResolver<?, ?> get(Class<TransientResolver<?, ?>> type, JSqlClient sqlClient) throws Exception {
        Map map = this.ctx.getBeansOfType(type);
        if (map.isEmpty()) {
            return super.get(type, sqlClient);
        }
        if (map.size() > 1) {
            throw new IllegalStateException("Two many spring beans whose type is \"" + type.getName() + "\"");
        }
        return (TransientResolver)map.values().iterator().next();
    }

    public TransientResolver<?, ?> get(String ref, JSqlClient sqlClient) throws Exception {
        Object bean = this.ctx.getBean(ref);
        if (!(bean instanceof TransientResolver)) {
            throw new IllegalStateException("The expected type of spring bean named \"ref\" is \"" + TransientResolver.class.getName() + "\", but the actual type is + \"" + bean.getClass().getName() + "\"");
        }
        return (TransientResolver)bean;
    }

    public final boolean shouldResolversBeCreatedImmediately() {
        return false;
    }
}

