/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import org.babyfish.jimmer.client.meta.ApiService;
import org.babyfish.jimmer.client.meta.Schema;
import org.babyfish.jimmer.client.runtime.impl.MetadataBuilder;
import org.babyfish.jimmer.spring.cfg.JimmerProperties;
import org.babyfish.jimmer.spring.client.OpenApiController;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Controller
public class OpenApiUiController {
    private static final String CSS_RESOURCE = "META-INF/jimmer/swagger/swagger-ui.css";
    private static final String JS_RESOURCE = "META-INF/jimmer/swagger/swagger-ui.js";
    private static final String CSS_URL = "/jimmer-client/swagger-ui.css";
    private static final String JS_URL = "/jimmer-client/swagger-ui.js";
    private final JimmerProperties properties;

    public OpenApiUiController(JimmerProperties properties) {
        this.properties = properties;
    }

    @GetMapping(value={"${jimmer.client.openapi.ui-path}"})
    public ResponseEntity<StreamingResponseBody> download(@RequestParam(name="groups", required=false) String groups) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "text/html");
        StreamingResponseBody body = out -> {
            OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
            String html = this.html(groups);
            writer.write(html);
            ((Writer)writer).flush();
        };
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)body);
    }

    private String html(String groups) {
        String refPath = this.properties.getClient().getOpenapi().getRefPath();
        String resource = this.hasMetadata() ? (refPath != null && !refPath.isEmpty() ? "META-INF/jimmer/openapi/index.html.template" : "META-INF/jimmer/openapi/no-api.html") : "META-INF/jimmer/openapi/no-metadata.html";
        StringBuilder builder = new StringBuilder();
        char[] buf = new char[1024];
        InputStream inputStream = OpenApiController.class.getClassLoader().getResourceAsStream(resource);
        assert (inputStream != null);
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            int len = reader.read(buf);
            if (len != -1) {
                builder.append(buf, 0, len);
            }
        }
        catch (IOException ex) {
            throw new AssertionError((Object)("Internal bug: Can read \"" + resource + "\""));
        }
        boolean isTemplate = resource.endsWith(".template");
        if (!isTemplate) {
            return builder.toString();
        }
        if (groups != null && !groups.isEmpty()) {
            try {
                refPath = refPath + "?groups=" + URLEncoder.encode(groups, "utf-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new AssertionError((Object)"Internal bug: utf-8 is not supported");
            }
        }
        return builder.toString().replace("${openapi.css}", OpenApiUiController.exists(CSS_RESOURCE) ? CSS_URL : "https://unpkg.com/swagger-ui-dist@5.10.5/swagger-ui.css").replace("${openapi.js}", OpenApiUiController.exists(JS_RESOURCE) ? JS_URL : "https://unpkg.com/swagger-ui-dist@5.10.5/swagger-ui-bundle.js").replace("${openapi.refPath}", refPath);
    }

    private boolean hasMetadata() {
        Schema schema = MetadataBuilder.loadSchema(Collections.emptySet());
        for (ApiService service : schema.getApiServiceMap().values()) {
            if (service.getOperations().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @GetMapping(value={"/jimmer-client/swagger-ui.css"})
    public ResponseEntity<StreamingResponseBody> css() throws IOException {
        return this.downloadResource(CSS_RESOURCE, "text/css");
    }

    @GetMapping(value={"/jimmer-client/swagger-ui.js"})
    public ResponseEntity<StreamingResponseBody> js() throws IOException {
        return this.downloadResource(JS_RESOURCE, "text/javascript");
    }

    private ResponseEntity<StreamingResponseBody> downloadResource(String resource, String contentType) throws IOException {
        byte[] buf = new byte[4096];
        InputStream in = OpenApiController.class.getClassLoader().getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalStateException("The resource \"" + resource + "\" does not exist");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", contentType);
        StreamingResponseBody body = out -> {
            try {
                int len;
                while ((len = in.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
                out.flush();
            }
            finally {
                in.close();
            }
        };
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)body);
    }

    private static boolean exists(String resource) {
        Enumeration<URL> enumeration;
        try {
            enumeration = OpenApiController.class.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to check the existence of resource \"" + resource + "\"");
        }
        return enumeration.hasMoreElements();
    }
}

