/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.babyfish.jimmer.spring.repository.JRepository;
import org.babyfish.jimmer.spring.repository.KRepository;
import org.babyfish.jimmer.spring.repository.support.JimmerRepositoryFactoryBean;
import org.babyfish.jimmer.sql.Entity;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.util.StringUtils;

public class JimmerRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    @NotNull
    public String getModuleName() {
        return "Jimmer";
    }

    @NotNull
    public String getRepositoryFactoryBeanClassName() {
        return JimmerRepositoryFactoryBean.class.getName();
    }

    @NotNull
    protected String getModulePrefix() {
        return this.getModuleName().toLowerCase(Locale.US);
    }

    @NotNull
    public void postProcess(@NotNull BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        source.getAttribute("sqlClientRef").filter(StringUtils::hasText).ifPresent(s -> builder.addPropertyReference("sqlClient", s));
    }

    @NotNull
    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Entity.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Arrays.asList(JRepository.class, KRepository.class);
    }
}

