/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.transaction;

import java.util.Objects;
import javax.sql.DataSource;
import org.babyfish.jimmer.spring.cfg.support.DataSourceAwareConnectionManager;
import org.babyfish.jimmer.spring.transaction.JTransactionalSqlClient;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.kt.KSqlClient;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.support.JdbcTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class JimmerTransactionManager
extends JdbcTransactionManager {
    private static final ThreadLocal<Frame> FRAME_THREAD_LOCAL = new ThreadLocal();
    private final JSqlClient sqlClient;

    public JimmerTransactionManager(JSqlClient sqlClient) {
        super(JimmerTransactionManager.dataSourceOf(sqlClient));
        this.sqlClient = sqlClient;
    }

    public JimmerTransactionManager(KSqlClient sqlClient) {
        this((JSqlClient)sqlClient.getJavaClient());
    }

    @Deprecated
    public final void setDatabaseProductName(String dbName) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void setDataSource(DataSource dataSource) {
        DataSource oldDataSource = this.getDataSource();
        if (oldDataSource == null) {
            super.setDataSource(dataSource);
        } else if (oldDataSource != dataSource) {
            throw new IllegalStateException("dataSource has already been set");
        }
    }

    protected void doBegin(@NotNull Object transaction, @NotNull TransactionDefinition definition) {
        Frame frame = new Frame(this.sqlClient, FRAME_THREAD_LOCAL.get());
        FRAME_THREAD_LOCAL.set(frame);
        super.doBegin(transaction, definition);
    }

    protected void doCleanupAfterCompletion(@NotNull Object transaction) {
        Frame oldFrame;
        super.doCleanupAfterCompletion(transaction);
        Frame frame = FRAME_THREAD_LOCAL.get();
        Frame frame2 = oldFrame = frame != null ? frame.parent : null;
        if (oldFrame == null) {
            FRAME_THREAD_LOCAL.remove();
        } else {
            FRAME_THREAD_LOCAL.set(oldFrame);
        }
    }

    public static JSqlClient sqlClient() {
        Frame frame = FRAME_THREAD_LOCAL.get();
        return frame != null ? frame.sqlClient : null;
    }

    private static DataSource dataSourceOf(JSqlClient sqlClient) {
        Objects.requireNonNull(sqlClient, "sqlClient cannot be null");
        if (sqlClient instanceof JTransactionalSqlClient) {
            throw new IllegalArgumentException("JimmerTransactionManager does not accept \"" + JTransactionalSqlClient.class.getName() + "\"");
        }
        ConnectionManager connectionManager = ((JSqlClientImplementor)sqlClient).getConnectionManager();
        if (!(connectionManager instanceof DataSourceAwareConnectionManager)) {
            throw new IllegalArgumentException("The data source of sql client must be an instance of \"" + DataSourceAwareConnectionManager.class.getName() + "\"");
        }
        return ((DataSourceAwareConnectionManager)connectionManager).getDataSource();
    }

    private static class Frame {
        final JSqlClient sqlClient;
        final Frame parent;

        private Frame(JSqlClient sqlClient, Frame parent) {
            this.sqlClient = sqlClient;
            this.parent = parent;
        }
    }
}

