/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.bytecode;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.babyfish.jimmer.impl.asm.ClassWriter;
import org.babyfish.jimmer.impl.asm.MethodVisitor;
import org.babyfish.jimmer.impl.asm.Type;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.spring.repository.bytecode.Constants;
import org.babyfish.jimmer.spring.repository.bytecode.MethodCodeWriter;
import org.babyfish.jimmer.spring.repository.parser.Context;
import org.springframework.data.repository.core.RepositoryInformation;

public abstract class ClassCodeWriter
implements Constants {
    public static final String ASM_IMPL_SUFFIX = "{AsmImpl}";
    final RepositoryInformation metadata;
    private final Class<?> superType;
    private final String interfaceInternalName;
    private final String implInternalName;
    private final String superInternalName;
    private final String entityInternalName;
    private final String sqlClientDescriptor;
    protected final List<MethodCodeWriter> methodCodeWriters;
    protected final List<MethodCodeWriter> autoGenMethodCodeWriters;
    private ClassWriter cw;
    Context ctx = new Context();

    protected ClassCodeWriter(RepositoryInformation metadata, Class<?> sqlClientType, Class<?> superType) {
        this.metadata = metadata;
        this.superType = superType;
        this.interfaceInternalName = Type.getInternalName((Class)metadata.getRepositoryInterface());
        this.implInternalName = this.interfaceInternalName + ASM_IMPL_SUFFIX;
        this.superInternalName = Type.getInternalName(superType);
        this.entityInternalName = Type.getInternalName((Class)metadata.getDomainType());
        this.sqlClientDescriptor = Type.getDescriptor(sqlClientType);
        Class repositoryInterface = metadata.getRepositoryInterface();
        ArrayList<MethodCodeWriter> list = new ArrayList<MethodCodeWriter>();
        HashMap<String, Integer> methodNameCountMap = new HashMap<String, Integer>();
        for (Method method : repositoryInterface.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass().isAssignableFrom(superType)) continue;
            Integer count2 = (Integer)methodNameCountMap.get(method.getName());
            if (count2 == null) {
                list.add(this.createMethodCodeWriter(method, method.getName()));
                methodNameCountMap.put(method.getName(), 1);
                continue;
            }
            count2 = count2 + 1;
            list.add(this.createMethodCodeWriter(method, method.getName() + ":" + count2));
            methodNameCountMap.put(method.getName(), count2);
        }
        this.methodCodeWriters = list;
        this.autoGenMethodCodeWriters = list.stream().filter(it -> !it.method.isDefault() && it.getDefaultImplMethod() == null).collect(Collectors.toList());
    }

    public RepositoryInformation getMetadata() {
        return this.metadata;
    }

    public String getInterfaceInternalName() {
        return this.interfaceInternalName;
    }

    public String getImplInternalName() {
        return this.implInternalName;
    }

    public String getEntityInternalName() {
        return this.entityInternalName;
    }

    public ClassWriter getClassVisitor() {
        return this.cw;
    }

    public byte[] write() {
        this.cw = new ClassWriter(3);
        this.cw.visit(52, 1, this.implInternalName, null, this.superInternalName, new String[]{this.interfaceInternalName});
        this.writeInit();
        if (!this.autoGenMethodCodeWriters.isEmpty()) {
            this.writeStaticFields();
            this.writeClinit();
        }
        for (MethodCodeWriter writer : this.methodCodeWriters) {
            writer.write();
        }
        this.cw.visitEnd();
        return this.cw.toByteArray();
    }

    private void writeInit() {
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", '(' + this.sqlClientDescriptor + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)Type.getType((Class)this.metadata.getDomainType()));
        mv.visitMethodInsn(183, this.superInternalName, "<init>", "(" + this.sqlClientDescriptor + "Ljava/lang/Class;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void writeStaticFields() {
        for (MethodCodeWriter writer : this.autoGenMethodCodeWriters) {
            this.cw.visitField(26, writer.queryMethodFieldName(), QUERY_METHOD_DESCRIPTOR, null, null).visitEnd();
        }
    }

    private void writeClinit() {
        MethodVisitor mv = this.cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, CONTEXT_INTERNAL_NAME);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, CONTEXT_INTERNAL_NAME, "<init>", "()V", false);
        mv.visitVarInsn(58, 0);
        mv.visitLdcInsn((Object)Type.getType((Class)this.metadata.getDomainType()));
        mv.visitMethodInsn(184, IMMUTABLE_TYPE_INTERNAL_NAME, "get", "(Ljava/lang/Class;)" + IMMUTABLE_TYPE_DESCRIPTOR, true);
        mv.visitVarInsn(58, 1);
        for (MethodCodeWriter writer : this.autoGenMethodCodeWriters) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)Type.getType((Class)this.metadata.getRepositoryInterface()));
            mv.visitLdcInsn((Object)writer.method.getName());
            mv.visitLdcInsn((Object)writer.method.getParameterTypes().length);
            mv.visitTypeInsn(189, "java/lang/Class");
            int index = 0;
            for (Class<?> clazz : writer.method.getParameterTypes()) {
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)index++);
                if (clazz.isPrimitive()) {
                    mv.visitFieldInsn(178, Type.getInternalName((Class)Classes.boxTypeOf(clazz)), "TYPE", "Ljava/lang/Class;");
                } else {
                    mv.visitLdcInsn((Object)Type.getType(clazz));
                }
                mv.visitInsn(83);
            }
            mv.visitMethodInsn(182, "java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)" + METHOD_DESCRIPTOR, false);
            mv.visitMethodInsn(184, QUERY_METHOD_INTERNAL_NAME, "of", "(" + CONTEXT_DESCRIPTOR + IMMUTABLE_TYPE_DESCRIPTOR + METHOD_DESCRIPTOR + ")" + QUERY_METHOD_DESCRIPTOR, false);
            mv.visitFieldInsn(179, this.implInternalName, writer.queryMethodFieldName(), QUERY_METHOD_DESCRIPTOR);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected abstract MethodCodeWriter createMethodCodeWriter(Method var1, String var2);

    public static String implementationClassName(Class<?> itf) {
        return itf.getName() + ASM_IMPL_SUFFIX;
    }
}

