/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg.support;

import java.util.Map;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.di.DefaultUserIdGeneratorProvider;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;
import org.springframework.context.ApplicationContext;

public class SpringUserIdGeneratorProvider
extends DefaultUserIdGeneratorProvider {
    private final ApplicationContext ctx;

    public SpringUserIdGeneratorProvider(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public UserIdGenerator<?> get(Class<UserIdGenerator<?>> type, JSqlClient sqlClient) throws Exception {
        Map map = this.ctx.getBeansOfType(type);
        if (map.isEmpty()) {
            return (UserIdGenerator)super.get(type, sqlClient);
        }
        if (map.size() > 1) {
            throw new IllegalStateException("Two many spring beans whose type is \"" + type.getName() + "\"");
        }
        return (UserIdGenerator)map.values().iterator().next();
    }

    public UserIdGenerator<?> get(String ref, JSqlClient sqlClient) throws Exception {
        Object bean = this.ctx.getBean(ref);
        if (!(bean instanceof UserIdGenerator)) {
            throw new IllegalStateException("The expected type of spring bean named \"ref\" is \"" + UserIdGenerator.class.getName() + "\", but the actual type is + \"" + bean.getClass().getName() + "\"");
        }
        return (UserIdGenerator)bean;
    }
}

