/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.parser;

import java.util.List;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.repository.parser.Context;
import org.babyfish.jimmer.spring.repository.parser.Path;
import org.babyfish.jimmer.spring.repository.parser.Predicate;
import org.babyfish.jimmer.spring.repository.parser.QueryParser;
import org.babyfish.jimmer.spring.repository.parser.Source;
import org.babyfish.jimmer.sql.ast.query.OrderMode;

public class Query {
    private final Action action;
    private final int limit;
    private final boolean distinct;
    private final Path selectedPath;
    private final Predicate predicate;
    private final List<Order> orders;

    public Query(Action action, int limit, boolean distinct, Path selectedPath, Predicate predicate, List<Order> orders) {
        this.action = action;
        this.limit = limit;
        this.distinct = distinct;
        this.selectedPath = selectedPath;
        this.predicate = predicate;
        this.orders = orders;
    }

    public Query(Query base, Predicate predicate) {
        this.action = base.action;
        this.limit = base.limit;
        this.distinct = base.distinct;
        this.selectedPath = base.selectedPath;
        this.predicate = predicate;
        this.orders = base.orders;
    }

    public Action getAction() {
        return this.action;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Path getSelectedPath() {
        return this.selectedPath;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public String toString() {
        return "Query{action=" + (Object)((Object)this.action) + ", limit=" + this.limit + ", distinct=" + this.distinct + ", selectedPath=" + this.selectedPath + ", predicate=" + this.predicate + ", orders=" + this.orders + '}';
    }

    public static Query of(Context ctx, Source source, ImmutableType type) {
        return new QueryParser(ctx, type).parse(source, true);
    }

    public static Query of(Context ctx, Source source, ImmutableType type, boolean allowProjection) {
        return new QueryParser(ctx, type).parse(source, allowProjection);
    }

    public static enum Action {
        FIND,
        COUNT,
        EXISTS,
        DELETE;

    }

    public static class Order {
        private final Path path;
        private final OrderMode orderMode;

        public Order(Path path, OrderMode orderMode) {
            this.path = path;
            this.orderMode = orderMode;
        }

        public Path getPath() {
            return this.path;
        }

        public OrderMode getOrderMode() {
            return this.orderMode;
        }

        public String toString() {
            return "Order{path=" + this.path + ", orderMode=" + this.orderMode + '}';
        }
    }
}

