/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg;

import graphql.GraphQL;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeRuntimeWiring;
import java.util.Collection;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.meta.impl.TypedPropImpl;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.kt.KSqlClient;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.dataloader.DataLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.graphql.execution.BatchLoaderRegistry;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import reactor.core.publisher.Mono;

@ConditionalOnClass(value={GraphQL.class, GraphQlSource.class})
public class JimmerSpringGraphQLAutoConfiguration {
    public JimmerSpringGraphQLAutoConfiguration(BatchLoaderRegistry registry, @Autowired(required=false) JSqlClient jSqlClient, @Autowired(required=false) KSqlClient kSqlClient) {
        JSqlClientImplementor sqlClient = JimmerSpringGraphQLAutoConfiguration.sqlClient(jSqlClient, kSqlClient);
        for (ImmutableType type : sqlClient.getEntityManager().getAllTypes(sqlClient.getMicroServiceName())) {
            if (!type.isEntity()) continue;
            for (ImmutableProp prop : type.getProps().values()) {
                if (prop.isReference(TargetLevel.ENTITY)) {
                    registry.forName(prop.toString()).registerMappedBatchLoader((sources, env) -> Mono.just((Object)sqlClient.getLoaders().reference((TypedProp.Reference)new TypedPropImpl.Reference(prop)).batchLoad((Collection)sources)));
                    continue;
                }
                if (prop.isReferenceList(TargetLevel.ENTITY)) {
                    registry.forName(prop.toString()).registerMappedBatchLoader((sources, env) -> Mono.just((Object)sqlClient.getLoaders().list((TypedProp.ReferenceList)new TypedPropImpl.ReferenceList(prop)).batchLoad((Collection)sources)));
                    continue;
                }
                if (!prop.hasTransientResolver()) continue;
                registry.forName(prop.toString()).registerMappedBatchLoader((sources, env) -> Mono.just((Object)sqlClient.getLoaders().value((TypedProp.Scalar)new TypedPropImpl.Scalar(prop)).batchLoad((Collection)sources)));
            }
        }
    }

    @Bean
    public RuntimeWiringConfigurer jimmerRuntimeWiringConfigurer(@Autowired(required=false) JSqlClient jSqlClient, @Autowired(required=false) KSqlClient kSqlClient) {
        JSqlClientImplementor sqlClient = JimmerSpringGraphQLAutoConfiguration.sqlClient(jSqlClient, kSqlClient);
        return wiringBuilder -> JimmerSpringGraphQLAutoConfiguration.registerJimmerDataFetchers(wiringBuilder, sqlClient);
    }

    private static void registerJimmerDataFetchers(RuntimeWiring.Builder wiringBuilder, JSqlClientImplementor sqlClient) {
        for (ImmutableType type : sqlClient.getEntityManager().getAllTypes(sqlClient.getMicroServiceName())) {
            if (!type.isEntity()) continue;
            TypeRuntimeWiring.Builder typeBuilder = TypeRuntimeWiring.newTypeWiring((String)type.getJavaClass().getSimpleName());
            for (ImmutableProp prop : type.getProps().values()) {
                if (prop.isAssociation(TargetLevel.ENTITY) || prop.hasTransientResolver()) {
                    typeBuilder.dataFetcher(prop.getName(), (DataFetcher)new JimmerComplexFetcher(prop));
                    continue;
                }
                typeBuilder.dataFetcher(prop.getName(), (DataFetcher)new JimmerSimpleFetcher(prop.getId()));
            }
            wiringBuilder.type(typeBuilder);
        }
    }

    private static JSqlClientImplementor sqlClient(JSqlClient jSqlClient, KSqlClient kSqlClient) {
        return (JSqlClientImplementor)(jSqlClient != null ? jSqlClient : kSqlClient.getJavaClient());
    }

    private static class JimmerComplexFetcher
    implements DataFetcher<Object> {
        private final ImmutableProp prop;

        JimmerComplexFetcher(ImmutableProp prop) {
            this.prop = prop;
        }

        public Object get(DataFetchingEnvironment env) {
            DataLoader dataLoader;
            ImmutableSpi spi = (ImmutableSpi)env.getSource();
            if (spi.__isLoaded(this.prop.getId())) {
                Object value = spi.__get(this.prop.getId());
                if (value == null) {
                    return null;
                }
                if (!new UnloadedContext(env).isUnloaded(value)) {
                    return value;
                }
            }
            if ((dataLoader = env.getDataLoaderRegistry().getDataLoader(this.prop.toString())) == null) {
                throw new IllegalStateException("No DataLoader for key '" + this.prop + "'");
            }
            return dataLoader.load(env.getSource());
        }
    }

    private static class JimmerSimpleFetcher
    implements DataFetcher<Object> {
        private final PropId propId;

        JimmerSimpleFetcher(PropId propId) {
            this.propId = propId;
        }

        public Object get(DataFetchingEnvironment env) throws Exception {
            ImmutableSpi spi = (ImmutableSpi)env.getSource();
            return spi.__get(this.propId);
        }
    }

    private static class UnloadedContext {
        private final DataFetchingEnvironment env;

        private UnloadedContext(DataFetchingEnvironment env) {
            this.env = env;
        }

        boolean isUnloaded(Object value) {
            SelectionSet selectionSet = this.env.getMergedField().getSingleField().getSelectionSet();
            if (value instanceof List) {
                for (Object e : (List)value) {
                    if (!this.isUnloaded((ImmutableSpi)e, selectionSet)) continue;
                    return true;
                }
            } else {
                return this.isUnloaded((ImmutableSpi)value, selectionSet);
            }
            return false;
        }

        boolean isUnloaded(ImmutableSpi spi, SelectionSet selectionSet) {
            for (Selection selection : selectionSet.getSelections()) {
                if (!(selection instanceof FragmentSpread ? this.isUnloaded(spi, (FragmentSpread)selection) : (selection instanceof InlineFragment ? this.isUnloaded(spi, (InlineFragment)selection) : this.isUnloaded(spi, (Field)selection)))) continue;
                return true;
            }
            return false;
        }

        private boolean isUnloaded(ImmutableSpi spi, Field field) {
            if (field.getArguments() != null && !field.getArguments().isEmpty()) {
                return false;
            }
            ImmutableProp prop = (ImmutableProp)spi.__type().getProps().get(field.getName());
            if (prop == null) {
                return false;
            }
            return !spi.__isLoaded(prop.getId());
        }

        private boolean isUnloaded(ImmutableSpi spi, FragmentSpread fragmentSpread) {
            FragmentDefinition definition = (FragmentDefinition)this.env.getFragmentsByName().get(fragmentSpread.getName());
            return definition != null && this.isUnloaded(spi, definition.getSelectionSet());
        }

        private boolean isUnloaded(ImmutableSpi spi, InlineFragment inlineFragment) {
            return this.isUnloaded(spi, inlineFragment.getSelectionSet());
        }
    }
}

