/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.parser;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kotlin.reflect.KClass;
import org.babyfish.jimmer.Page;
import org.babyfish.jimmer.Specification;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.repository.parser.AndPredicate;
import org.babyfish.jimmer.spring.repository.parser.Context;
import org.babyfish.jimmer.spring.repository.parser.OrPredicate;
import org.babyfish.jimmer.spring.repository.parser.Predicate;
import org.babyfish.jimmer.spring.repository.parser.PropPredicate;
import org.babyfish.jimmer.spring.repository.parser.Query;
import org.babyfish.jimmer.spring.repository.parser.QueryMethod;
import org.babyfish.jimmer.spring.repository.parser.Source;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

class QueryMethodParser {
    private final Context ctx;
    private final ImmutableType type;
    private final Method method;
    private final Class<?>[] parameterTypes;
    private final Type[] genericParameterTypes;
    private final int pageableParamIndex;
    private final int sortParamIndex;
    private final int specificationIndex;
    private final int fetcherParamIndex;
    private Class<?> viewType;
    private final int viewTypeParamIndex;
    private int paramIndex = -1;
    private int logicParamIndex = -1;

    private QueryMethodParser(Context ctx, ImmutableType type, Method method) {
        this.ctx = ctx;
        this.type = type;
        this.method = method;
        this.parameterTypes = method.getParameterTypes();
        this.genericParameterTypes = method.getGenericParameterTypes();
        this.pageableParamIndex = this.implicitParameterIndex(Pageable.class);
        this.sortParamIndex = this.implicitParameterIndex(Sort.class);
        this.specificationIndex = this.implicitParameterIndex(Specification.class);
        this.fetcherParamIndex = this.implicitParameterIndex(Fetcher.class);
        int vtpIndex = this.implicitParameterIndex(Class.class);
        if (vtpIndex == -1) {
            vtpIndex = this.implicitParameterIndex(KClass.class);
        }
        this.viewTypeParamIndex = vtpIndex;
        if (this.pageableParamIndex != -1 && this.sortParamIndex != -1) {
            throw new IllegalArgumentException("Cannot have parameters of type \"" + Pageable.class.getName() + "\" and \"" + Sort.class.getName() + "\" at the same time");
        }
    }

    static QueryMethod parse(Context ctx, ImmutableType type, Method method) {
        return new QueryMethodParser(ctx, type, method).parse();
    }

    private QueryMethod parse() {
        try {
            return this.parse0();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Illegal abstract spring-data method \"" + this.method + "\": " + ex.getMessage(), ex);
        }
    }

    private QueryMethod parse0() {
        ParameterizedType parameterizedType;
        Type actualElementType = this.method.getGenericReturnType();
        if (actualElementType instanceof ParameterizedType) {
            actualElementType = ((ParameterizedType)actualElementType).getActualTypeArguments()[0];
        }
        boolean isObjectQuery = actualElementType == this.type.getJavaClass();
        Query query = Query.of(this.ctx, new Source(this.method.getName()), this.type, !isObjectQuery);
        if (query.getPredicate() != null) {
            query = new Query(query, this.resolve(query.getPredicate()));
        }
        while (++this.paramIndex < this.parameterTypes.length) {
            if (QueryMethodParser.isImplicitParameterType(this.parameterTypes[this.paramIndex])) continue;
            throw new IllegalArgumentException("Too many parameters");
        }
        if (QueryMethodParser.isPage(this.method.getReturnType()) && this.pageableParamIndex == -1) {
            throw new IllegalArgumentException("Return type \"" + this.method.getReturnType() + "\" requires parameter whose type is \"" + Pageable.class + "\"");
        }
        if (!QueryMethodParser.isPage(this.method.getReturnType()) && this.pageableParamIndex != -1) {
            throw new IllegalArgumentException("The parameter whose type is \"" + Pageable.class + "\" requires the return type \"" + org.springframework.data.domain.Page.class.getName() + "\" or \"" + Page.class.getName() + "\"");
        }
        if (query.getAction() == Query.Action.FIND) {
            Type genericReturnType;
            Class entityType = this.type.getJavaClass();
            Class<?> returnType = this.method.getReturnType();
            if ((returnType == List.class || returnType == Collection.class || returnType == Iterable.class || QueryMethodParser.isPage(this.method.getReturnType()) || returnType == Optional.class) && !((genericReturnType = this.method.getGenericReturnType()) instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Return type must be parameterized type when raw return type is \"" + List.class.getName() + "\", \"" + Collection.class.getName() + "\", \"" + Iterator.class.getName() + "\", \"" + org.springframework.data.domain.Page.class.getName() + "\", \"" + Page.class.getName() + "\" or \"" + Optional.class + "\"");
            }
            if (query.getSelectedPath() != null) {
                if (actualElementType != query.getSelectedPath().getType()) {
                    throw new IllegalArgumentException("The returned element type must be \"" + query.getSelectedPath().getType() + "\"");
                }
            } else {
                ReturnedElementType returnedElementType = this.returnedElementType(actualElementType, entityType);
                if (returnedElementType == null) {
                    throw new IllegalArgumentException("The returned element type must be \"" + entityType.getName() + "\", a class implements \"" + View.class.getName() + "<" + entityType.getName() + ">\" or a method level type variable extends \"" + View.class.getName() + "<" + entityType.getName() + ">\"");
                }
                this.viewType = returnedElementType.viewType;
            }
            if (query.getSelectedPath() == null && actualElementType instanceof TypeVariable) {
                Type typeArgument;
                if (this.viewTypeParamIndex == -1) {
                    throw new IllegalArgumentException("A parameter whose type is \"Class<" + ((TypeVariable)actualElementType).getName() + ">\" or \"KClass<" + ((TypeVariable)actualElementType).getName() + ">\" is required");
                }
                Type type = this.method.getGenericParameterTypes()[this.viewTypeParamIndex];
                boolean valid = false;
                if (type instanceof ParameterizedType && (typeArgument = ((ParameterizedType)type).getActualTypeArguments()[0]) == actualElementType) {
                    valid = true;
                }
                if (!valid) {
                    throw new IllegalArgumentException("The type argument of parameters[" + this.viewTypeParamIndex + "] must be the type variable \"" + ((TypeVariable)actualElementType).getName() + "\"");
                }
            } else if (this.viewTypeParamIndex != -1) {
                throw new IllegalArgumentException("The parameters[" + this.viewTypeParamIndex + "] is illegal");
            }
        } else if (query.getAction() == Query.Action.EXISTS) {
            if (this.method.getReturnType() != Boolean.TYPE) {
                throw new IllegalArgumentException("The return type must be boolean");
            }
        } else if (query.getAction() == Query.Action.COUNT) {
            if (this.method.getReturnType() != Integer.TYPE && this.method.getReturnType() != Long.TYPE) {
                throw new IllegalArgumentException("The return type must be int or long");
            }
        } else if (query.getAction() == Query.Action.DELETE && this.method.getReturnType() != Integer.TYPE && this.method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException("The return type must be int or void");
        }
        if (this.specificationIndex != -1) {
            if (query.getAction() != Query.Action.FIND && query.getAction() != Query.Action.COUNT && query.getAction() != Query.Action.EXISTS) {
                throw new IllegalArgumentException("The method must be query method when there is a specification parameter");
            }
            Type specificationType = this.genericParameterTypes[this.specificationIndex];
            if (!(specificationType instanceof ParameterizedType)) {
                if (specificationType != Specification.class) {
                    throw new IllegalArgumentException("The specification parameter must be \"" + Specification.class.getName() + "<" + this.type.getJavaClass().getName() + ">\"");
                }
                throw new IllegalArgumentException("The specification parameter must be parameterized type");
            }
            parameterizedType = (ParameterizedType)specificationType;
            if (parameterizedType.getRawType() != Specification.class) {
                throw new IllegalArgumentException("The raw type of specification parameter must be \"" + Specification.class.getName() + "\"");
            }
            if (parameterizedType.getActualTypeArguments()[0] != this.type.getJavaClass()) {
                throw new IllegalArgumentException("The type argument of specification parameter must be \"" + this.type.getJavaClass().getName() + "\"");
            }
        }
        if (this.fetcherParamIndex != -1) {
            if (query.getAction() != Query.Action.FIND) {
                throw new IllegalArgumentException("The method must be object finding method when there is a fetcher parameter");
            }
            if (query.getSelectedPath() != null) {
                throw new IllegalArgumentException("Cannot explicitly select columns when there is a fetcher parameter");
            }
            Type fetcherType = this.genericParameterTypes[this.fetcherParamIndex];
            if (!(fetcherType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("The fetcher parameter must be parameterized type");
            }
            parameterizedType = (ParameterizedType)fetcherType;
            if (parameterizedType.getActualTypeArguments()[0] != this.type.getJavaClass()) {
                throw new IllegalArgumentException("The type argument of fetch parameter must be \"" + this.type.getJavaClass() + "\"");
            }
        }
        if (this.viewTypeParamIndex != -1 && query.getAction() != Query.Action.FIND) {
            throw new IllegalArgumentException("The method must be query method when there is a view type parameter");
        }
        if (this.pageableParamIndex != -1 && query.getAction() != Query.Action.FIND) {
            throw new IllegalArgumentException("The method must be query method when there is a pageable parameter");
        }
        if (this.sortParamIndex != -1 && query.getAction() != Query.Action.FIND) {
            throw new IllegalArgumentException("The method must be query method when there is a sort parameter");
        }
        return new QueryMethod(this.method, query, this.viewType, this.pageableParamIndex, this.sortParamIndex, this.specificationIndex, this.fetcherParamIndex, this.viewTypeParamIndex);
    }

    private ReturnedElementType returnedElementType(Type type, Class<?> entityType) {
        ParameterizedType parameterizedBoundType;
        Type boundType;
        TypeVariable typeVariable;
        if (type instanceof Class) {
            Class[] typeArguments;
            Class clazz = (Class)type;
            if (clazz == entityType) {
                return new ReturnedElementType(null);
            }
            if (View.class.isAssignableFrom(clazz) && (typeArguments = GenericTypeResolver.resolveTypeArguments((Class)clazz, View.class)) != null && typeArguments[0] == entityType) {
                return new ReturnedElementType(clazz);
            }
        } else if (type instanceof TypeVariable && (typeVariable = (TypeVariable)type).getGenericDeclaration() == this.method && (boundType = typeVariable.getBounds()[0]) instanceof ParameterizedType && (parameterizedBoundType = (ParameterizedType)boundType).getRawType() == View.class && parameterizedBoundType.getActualTypeArguments()[0] == entityType) {
            return new ReturnedElementType(null);
        }
        return null;
    }

    private Predicate resolve(Predicate predicate) {
        if (predicate instanceof AndPredicate) {
            return AndPredicate.of(((AndPredicate)predicate).getPredicates().stream().map(this::resolve).collect(Collectors.toList()));
        }
        if (predicate instanceof OrPredicate) {
            return OrPredicate.of(((OrPredicate)predicate).getPredicates().stream().map(this::resolve).collect(Collectors.toList()));
        }
        if (predicate instanceof PropPredicate) {
            return this.resolve((PropPredicate)predicate);
        }
        throw new AssertionError((Object)("Internal bug, unexpected prop predicate: " + predicate));
    }

    private Predicate resolve(PropPredicate propPredicate) {
        if (!propPredicate.getPath().isScalar() && propPredicate.getOp() != PropPredicate.Op.NULL && propPredicate.getOp() != PropPredicate.Op.NOT_NULL) {
            throw new IllegalArgumentException("Illegal property \"" + propPredicate.getPath() + "\" of \"" + propPredicate.getPath().getSource() + "\", it cannot be reference property when the predicate is nether `IsNull` nor `IsNotNull`");
        }
        switch (propPredicate.getOp()) {
            case TRUE: 
            case FALSE: {
                if (!Classes.matches(propPredicate.getPath().getType(), Boolean.TYPE)) {
                    throw new IllegalArgumentException("Illegal property \"" + propPredicate.getPath() + "\", its type must be boolean when the predicate is `IsTrue` or `IsFalse`");
                }
                return ((PropPredicate.Unresolved)propPredicate).resolve();
            }
            case NULL: 
            case NOT_NULL: {
                return ((PropPredicate.Unresolved)propPredicate).resolve();
            }
            case EQ: 
            case NE: 
            case LT: 
            case LE: 
            case GT: 
            case GE: 
            case LIKE: 
            case NOT_LIKE: 
            case IN: 
            case NOT_IN: {
                return ((PropPredicate.Unresolved)propPredicate).resolve(this.nextParam(propPredicate));
            }
            case BETWEEN: 
            case NOT_BETWEEN: {
                return ((PropPredicate.Unresolved)propPredicate).resolve(this.nextParam(propPredicate), this.nextParam(propPredicate));
            }
        }
        throw new AssertionError((Object)("Internal bug: unexpected predicate op: " + (Object)((Object)propPredicate.getOp())));
    }

    private Param nextParam(PropPredicate predicate) {
        ++this.paramIndex;
        while (this.paramIndex < this.parameterTypes.length && QueryMethodParser.isImplicitParameterType(this.parameterTypes[this.paramIndex])) {
            ++this.paramIndex;
        }
        if (this.paramIndex >= this.parameterTypes.length) {
            throw new IllegalArgumentException("No enough parameters for the property \"" + predicate.getPath() + "\" of \"" + predicate.getPath().getSource() + "\"");
        }
        String expectedTypeName = null;
        String actualTypeName = null;
        boolean isCollection = false;
        if (predicate.getOp() == PropPredicate.Op.IN || predicate.getOp() == PropPredicate.Op.NOT_IN) {
            ParameterizedType parameterizedType;
            boolean valid = false;
            ParameterizedType parameterizedType2 = parameterizedType = this.genericParameterTypes[this.paramIndex] instanceof ParameterizedType ? (ParameterizedType)this.genericParameterTypes[this.paramIndex] : null;
            if (parameterizedType != null && (parameterizedType.getRawType() == Collection.class || parameterizedType.getRawType() == List.class)) {
                boolean bl = valid = Classes.boxTypeOf(predicate.getPath().getType()) == parameterizedType.getActualTypeArguments()[0];
            }
            if (!valid) {
                expectedTypeName = "Collection<" + Classes.boxTypeOf(predicate.getPath().getType()).getName() + '>';
                actualTypeName = parameterizedType == null ? this.parameterTypes[this.paramIndex].getName() : parameterizedType.getRawType().getTypeName() + '<' + Arrays.stream(parameterizedType.getActualTypeArguments()).map(Type::getTypeName).collect(Collectors.joining(", ")) + '>';
                isCollection = true;
            }
        } else if (!Classes.matches(this.parameterTypes[this.paramIndex], predicate.getPath().getType())) {
            expectedTypeName = predicate.getPath().getType().getName();
            actualTypeName = this.parameterTypes[this.paramIndex].getName();
        }
        if (expectedTypeName != null) {
            throw new IllegalArgumentException("This type of " + (isCollection ? "the collection whose element is the " : "") + "property \"" + predicate.getPath() + "\" is \"" + expectedTypeName + "\", but the type of parameters[" + this.paramIndex + "] of java method is \"" + actualTypeName + "\"");
        }
        return new Param(this.paramIndex, ++this.logicParamIndex);
    }

    private static boolean isImplicitParameterType(Class<?> type) {
        return Pageable.class.isAssignableFrom(type) || Sort.class.isAssignableFrom(type) || Specification.class.isAssignableFrom(type) || Fetcher.class.isAssignableFrom(type) || Class.class.isAssignableFrom(type) || KClass.class.isAssignableFrom(type);
    }

    private int implicitParameterIndex(Class<?> type) {
        int index = -1;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (!type.isAssignableFrom(this.parameterTypes[i])) continue;
            if (index != -1) {
                throw new IllegalArgumentException("Both parameters[" + index + "] and parameters[" + i + "] are of type \"" + type.getName() + "\"");
            }
            index = i;
        }
        return index;
    }

    private static boolean isPage(Class<?> returnType) {
        return returnType == org.springframework.data.domain.Page.class || returnType == Page.class;
    }

    static class ReturnedElementType {
        final Class<?> viewType;

        ReturnedElementType(Class<?> viewType) {
            this.viewType = viewType;
        }
    }

    static class Param {
        private final int index;
        private final int logicIndex;

        public Param(int index, int logicIndex) {
            this.index = index;
            this.logicIndex = logicIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLogicIndex() {
            return this.logicIndex;
        }

        public String toString() {
            return "Param{index=" + this.index + ", logicIndex=" + this.logicIndex + '}';
        }
    }
}

