/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.support;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.spring.repository.JRepository;
import org.babyfish.jimmer.spring.repository.SpringOrders;
import org.babyfish.jimmer.spring.repository.support.SpringPageFactory;
import org.babyfish.jimmer.spring.repository.support.Utils;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.mutation.Mutations;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.table.FetcherSelectionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.PagingQueries;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.ViewMetadata;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public class JRepositoryImpl<E, ID>
implements JRepository<E, ID> {
    protected final JSqlClientImplementor sqlClient;
    protected final Class<E> entityType;
    protected final ImmutableType immutableType;

    protected JRepositoryImpl(JSqlClient sqlClient) {
        this(sqlClient, null);
    }

    public JRepositoryImpl(JSqlClient sqlClient, Class<E> entityType) {
        this.sqlClient = Utils.validateSqlClient(sqlClient);
        if (entityType != null) {
            this.entityType = entityType;
        } else {
            Class[] typeArguments = GenericTypeResolver.resolveTypeArguments(this.getClass(), JRepository.class);
            if (typeArguments == null) {
                throw new IllegalArgumentException("The class \"" + this.getClass() + "\" does not explicitly specify the type arguments of \"" + JRepository.class.getName() + "\" so that the entityType must be specified");
            }
            this.entityType = entityType = typeArguments[0];
        }
        this.immutableType = ImmutableType.get(entityType);
        if (!this.immutableType.isEntity()) {
            throw new IllegalArgumentException("\"" + entityType + "\" is not entity type decorated by @" + Entity.class.getName());
        }
    }

    @Override
    public JSqlClient sql() {
        return this.sqlClient;
    }

    @Override
    public ImmutableType type() {
        return this.immutableType;
    }

    @Override
    public Class<E> entityType() {
        return this.entityType;
    }

    @Override
    @Deprecated
    public JRepository.Pager pager(Pageable pageable) {
        if (pageable == null || pageable.isUnpaged()) {
            return new PagerImpl(0, Integer.MAX_VALUE);
        }
        return new PagerImpl(pageable.getPageNumber(), pageable.getPageSize());
    }

    @Override
    @Deprecated
    public JRepository.Pager pager(int pageIndex, int pageSize) {
        return new PagerImpl(pageIndex, pageSize);
    }

    @Override
    public E findNullable(ID id) {
        return (E)this.sqlClient.getEntities().findById(this.entityType, id);
    }

    @Override
    public E findNullable(ID id, Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.findNullable(id);
        }
        return (E)this.sqlClient.getEntities().findById(fetcher, id);
    }

    @Override
    public List<E> findByIds(Iterable<ID> ids) {
        return this.sqlClient.getEntities().findByIds(this.entityType, Utils.toCollection(ids));
    }

    @Override
    public List<E> findByIds(Iterable<ID> ids, Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.findByIds(ids);
        }
        return this.sqlClient.getEntities().findByIds(fetcher, Utils.toCollection(ids));
    }

    @Override
    public Map<ID, E> findMapByIds(Iterable<ID> ids) {
        return this.sqlClient.getEntities().findMapByIds(this.entityType, Utils.toCollection(ids));
    }

    @Override
    public Map<ID, E> findMapByIds(Iterable<ID> ids, Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.findMapByIds(ids);
        }
        return this.sqlClient.getEntities().findMapByIds(fetcher, Utils.toCollection(ids));
    }

    @Override
    @NotNull
    public List<E> findAll() {
        return (List)this.createQuery(null, null, null, null).execute();
    }

    @Override
    public List<E> findAll(TypedProp.Scalar<?, ?> ... sortedProps) {
        return (List)this.createQuery(null, null, sortedProps, null).execute();
    }

    @Override
    public List<E> findAll(Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        return (List)this.createQuery(fetcher, null, sortedProps, null).execute();
    }

    @Override
    @NotNull
    public List<E> findAll(@NotNull Sort sort) {
        return (List)this.createQuery(null, null, null, sort).execute();
    }

    @Override
    public List<E> findAll(Fetcher<E> fetcher, Sort sort) {
        return (List)this.createQuery(fetcher, null, null, sort).execute();
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize) {
        return this.pager(pageIndex, pageSize).execute(this.createQuery(null, null, null, null));
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher) {
        return this.pager(pageIndex, pageSize).execute(this.createQuery(fetcher, null, null, null));
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.pager(pageIndex, pageSize).execute(this.createQuery(null, null, sortedProps, null));
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.pager(pageIndex, pageSize).execute(this.createQuery(fetcher, null, sortedProps, null));
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Sort sort) {
        return this.pager(pageIndex, pageSize).execute(this.createQuery(null, null, null, sort));
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher, Sort sort) {
        return this.pager(pageIndex, pageSize).execute(this.createQuery(fetcher, null, null, sort));
    }

    @Override
    @NotNull
    public Page<E> findAll(@NotNull Pageable pageable) {
        return (Page)this.createQuery(null, null, null, pageable.getSort()).fetchPage(pageable.getPageNumber(), pageable.getPageSize(), SpringPageFactory.getInstance());
    }

    @Override
    public Page<E> findAll(Pageable pageable, Fetcher<E> fetcher) {
        return (Page)this.createQuery(fetcher, null, null, pageable.getSort()).fetchPage(pageable.getPageNumber(), pageable.getPageSize(), SpringPageFactory.getInstance());
    }

    @Override
    public long count() {
        return this.createQuery(null, null, null, null).fetchUnlimitedCount();
    }

    @Override
    @NotNull
    public SimpleEntitySaveCommand<E> saveCommand(@NotNull Input<E> input) {
        return this.sqlClient.getEntities().saveCommand(input);
    }

    @Override
    @NotNull
    public <S extends E> SimpleEntitySaveCommand<S> saveCommand(@NotNull S entity) {
        return this.sqlClient.getEntities().saveCommand(entity);
    }

    @Override
    @NotNull
    public <S extends E> BatchEntitySaveCommand<S> saveEntitiesCommand(@NotNull Iterable<S> entities) {
        return this.sqlClient.getEntities().saveEntitiesCommand(Utils.toCollection(entities));
    }

    @Override
    public int delete(@NotNull E entity, DeleteMode mode) {
        return this.sqlClient.getEntities().delete(this.entityType, ImmutableObjects.get(entity, (PropId)this.immutableType.getIdProp().getId()), mode).getAffectedRowCount((AffectedTable)AffectedTable.of((ImmutableType)this.immutableType));
    }

    @Override
    public int deleteAll(@NotNull Iterable<? extends E> entities, DeleteMode mode) {
        return this.sqlClient.getEntities().deleteAll(this.entityType, (Collection)Utils.toCollection(entities).stream().map(it -> ImmutableObjects.get((Object)it, (PropId)this.immutableType.getIdProp().getId())).collect(Collectors.toList()), mode).getAffectedRowCount((AffectedTable)AffectedTable.of((ImmutableType)this.immutableType));
    }

    @Override
    public int deleteById(@NotNull ID id, DeleteMode mode) {
        return this.sqlClient.getEntities().delete(this.entityType, id, mode).getAffectedRowCount((AffectedTable)AffectedTable.of((ImmutableType)this.immutableType));
    }

    @Override
    public int deleteByIds(Iterable<? extends ID> ids, DeleteMode mode) {
        return this.sqlClient.getEntities().deleteAll(this.entityType, Utils.toCollection(ids), mode).getAffectedRowCount((AffectedTable)AffectedTable.of((ImmutableType)this.immutableType));
    }

    @Override
    public void deleteAll() {
        Mutations.createDelete((JSqlClientImplementor)this.sqlClient, (ImmutableType)this.immutableType, (d, t) -> {}).execute();
    }

    @Override
    public <V extends View<E>> JRepository.Viewer<E, ID, V> viewer(Class<V> viewType) {
        return new ViewerImpl(viewType);
    }

    private <X> ConfigurableRootQuery<?, X> createQuery(Fetcher<?> fetcher, @Nullable Function<?, X> converter, @Nullable TypedProp.Scalar<?, ?>[] sortedProps, @Nullable Sort sort) {
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, this.immutableType, ExecutionPurpose.QUERY, FilterLevel.DEFAULT);
        TableImplementor table = query.getTableImplementor();
        if (sortedProps != null) {
            for (TypedProp.Scalar<?, ?> sortedProp : sortedProps) {
                if (!sortedProp.unwrap().getDeclaringType().isAssignableFrom(this.immutableType)) {
                    throw new IllegalArgumentException("The sorted field \"" + sortedProp + "\" does not belong to the type \"" + this.immutableType + "\" or its super types");
                }
                PropExpression expr = table.get(sortedProp.unwrap());
                Order astOrder = sortedProp.isDesc() ? expr.desc() : expr.asc();
                if (sortedProp.isNullsFirst()) {
                    astOrder = astOrder.nullsFirst();
                }
                if (sortedProp.isNullsLast()) {
                    astOrder = astOrder.nullsLast();
                }
                query.orderBy(new Order[]{astOrder});
            }
        }
        if (sort != null) {
            query.orderBy(SpringOrders.toOrders((Props)table, sort));
        }
        return query.select((Selection)(fetcher != null ? new FetcherSelectionImpl((Table)table, fetcher, converter) : table));
    }

    @Deprecated
    private static class PagerImpl
    implements JRepository.Pager {
        private final int pageIndex;
        private final int pageSize;

        PagerImpl(int pageIndex, int pageSize) {
            this.pageIndex = pageIndex;
            this.pageSize = pageSize;
        }

        @Override
        public <T> Page<T> execute(ConfigurableRootQuery<?, T> query) {
            return (Page)PagingQueries.execute(query, (int)this.pageIndex, (int)this.pageSize, SpringPageFactory.getInstance());
        }
    }

    private class ViewerImpl<V extends View<E>>
    implements JRepository.Viewer<E, ID, V> {
        private final Class<V> viewType;
        private final ViewMetadata<E, V> metadata;

        private ViewerImpl(Class<V> viewType) {
            this.viewType = viewType;
            this.metadata = ViewMetadata.of(viewType);
        }

        @Override
        public V findNullable(ID id) {
            return (V)((View)JRepositoryImpl.this.sqlClient.getEntities().findById(this.viewType, id));
        }

        @Override
        public List<V> findByIds(Iterable<ID> ids) {
            return JRepositoryImpl.this.sqlClient.getEntities().findByIds(this.viewType, Utils.toCollection(ids));
        }

        @Override
        public Map<ID, V> findMapByIds(Iterable<ID> ids) {
            return JRepositoryImpl.this.sqlClient.getEntities().findMapByIds(this.viewType, Utils.toCollection(ids));
        }

        @Override
        public List<V> findAll() {
            return (List)JRepositoryImpl.this.createQuery(this.metadata.getFetcher(), this.metadata.getConverter(), null, null).execute();
        }

        @Override
        public List<V> findAll(TypedProp.Scalar<?, ?> ... sortedProps) {
            return (List)JRepositoryImpl.this.createQuery(this.metadata.getFetcher(), this.metadata.getConverter(), sortedProps, null).execute();
        }

        @Override
        public List<V> findAll(Sort sort) {
            return (List)JRepositoryImpl.this.createQuery(this.metadata.getFetcher(), this.metadata.getConverter(), null, sort).execute();
        }

        @Override
        public Page<V> findAll(Pageable pageable) {
            return JRepositoryImpl.this.pager(pageable).execute(JRepositoryImpl.this.createQuery(this.metadata.getFetcher(), this.metadata.getConverter(), null, pageable.getSort()));
        }

        @Override
        public Page<V> findAll(int pageIndex, int pageSize) {
            return JRepositoryImpl.this.pager(pageIndex, pageSize).execute(JRepositoryImpl.this.createQuery(this.metadata.getFetcher(), this.metadata.getConverter(), null, null));
        }

        @Override
        public Page<V> findAll(int pageIndex, int pageSize, TypedProp.Scalar<?, ?> ... sortedProps) {
            return JRepositoryImpl.this.pager(pageIndex, pageSize).execute(JRepositoryImpl.this.createQuery(this.metadata.getFetcher(), this.metadata.getConverter(), sortedProps, null));
        }

        @Override
        public Page<V> findAll(int pageIndex, int pageSize, Sort sort) {
            return JRepositoryImpl.this.pager(pageIndex, pageSize).execute(JRepositoryImpl.this.createQuery(this.metadata.getFetcher(), this.metadata.getConverter(), null, sort));
        }
    }
}

