/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.sql.cache.chain.CacheChain;
import org.babyfish.jimmer.sql.cache.chain.LoadingBinder;
import org.jetbrains.annotations.NotNull;

public class CaffeineBinder<K, V>
implements LoadingBinder<K, V> {
    private final int maximumSize;
    private final Duration duration;
    private LoadingCache<K, Ref<V>> loadingCache;

    public CaffeineBinder(int maximumSize, Duration duration) {
        this.maximumSize = maximumSize;
        this.duration = duration;
    }

    public void initialize(final CacheChain<K, V> chain) {
        this.loadingCache = Caffeine.newBuilder().maximumSize((long)this.maximumSize).expireAfterWrite(this.duration).build(new CacheLoader<K, Ref<V>>(){

            public Ref<V> load(K key) {
                Map map = chain.loadAll(Collections.singleton(key));
                Object value = map.get(key);
                if (value != null || map.containsKey(key)) {
                    return Ref.of(value);
                }
                return null;
            }

            public Map<K, Ref<V>> loadAll(Iterable<? extends K> keys) {
                Map map = chain.loadAll((Collection)keys);
                return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Ref.of(e.getValue())));
            }
        });
    }

    public Map<K, V> getAll(Collection<K> keys) {
        Map map = this.loadingCache.getAll(keys);
        HashMap convertedMap = new HashMap((map.size() * 4 + 2) / 3);
        for (Map.Entry e : map.entrySet()) {
            convertedMap.put(e.getKey(), ((Ref)e.getValue()).getValue());
        }
        return convertedMap;
    }

    public void deleteAll(@NotNull Collection<K> keys, Object reason) {
        if (reason == null || reason.equals("caffeine")) {
            this.loadingCache.invalidateAll(keys);
        }
    }
}

