/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg.support;

import java.sql.Connection;
import java.util.function.Function;
import javax.sql.DataSource;
import org.babyfish.jimmer.spring.cfg.support.DataSourceAwareConnectionManager;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class SpringConnectionManager
implements DataSourceAwareConnectionManager {
    private final DataSource dataSource;

    public SpringConnectionManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    @NotNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R execute(Function<Connection, R> block) {
        Connection con = DataSourceUtils.getConnection((DataSource)this.dataSource);
        try {
            R r = block.apply(con);
            return r;
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.dataSource);
        }
    }
}

