/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository;

import java.sql.Connection;
import java.util.function.Function;
import javax.sql.DataSource;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;

public final class SpringConnectionManager
implements ConnectionManager {
    private final DataSource dataSource;

    public SpringConnectionManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R execute(Function<Connection, R> block) {
        Connection con = DataSourceUtils.getConnection((DataSource)this.dataSource);
        try {
            R r = block.apply(con);
            return r;
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.dataSource);
        }
    }
}

