/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.support;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.spring.repository.SpringOrders;
import org.babyfish.jimmer.spring.repository.parser.AndPredicate;
import org.babyfish.jimmer.spring.repository.parser.OrPredicate;
import org.babyfish.jimmer.spring.repository.parser.Path;
import org.babyfish.jimmer.spring.repository.parser.Predicate;
import org.babyfish.jimmer.spring.repository.parser.PropPredicate;
import org.babyfish.jimmer.spring.repository.parser.Query;
import org.babyfish.jimmer.spring.repository.parser.QueryMethod;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.mutation.Mutations;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.OrderMode;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class QueryExecutors {
    private QueryExecutors() {
    }

    public static Object execute(JSqlClientImplementor sqlClient, ImmutableType type, QueryMethod queryMethod, Pageable pageable, Sort sort, Fetcher<?> fetcher, Object[] args) {
        Query queryData = queryMethod.getQuery();
        if (queryData.getAction() == Query.Action.DELETE) {
            int rowCount = (Integer)Mutations.createDelete((JSqlClientImplementor)sqlClient, (ImmutableType)type, (d, table) -> d.where(new org.babyfish.jimmer.sql.ast.Predicate[]{QueryExecutors.astPredicate(table, queryData.getPredicate(), args)})).execute();
            return queryMethod.getJavaMethod().getReturnType() == Integer.TYPE ? Integer.valueOf(rowCount) : null;
        }
        ConfigurableRootQuery query = Queries.createQuery((JSqlClientImplementor)sqlClient, (ImmutableType)type, (ExecutionPurpose)ExecutionPurpose.QUERY, (boolean)false, (q, table) -> {
            Sort finalSort;
            q.where(new org.babyfish.jimmer.sql.ast.Predicate[]{QueryExecutors.astPredicate(table, queryData.getPredicate(), args)});
            for (Query.Order order : queryData.getOrders()) {
                q.orderBy(new Order[]{order.getOrderMode() == OrderMode.DESC ? ((Expression)QueryExecutors.astSelection(table, order.getPath(), true)).desc() : ((Expression)QueryExecutors.astSelection(table, order.getPath(), true)).asc()});
            }
            Sort sort2 = finalSort = pageable != null ? pageable.getSort() : sort;
            if (finalSort != null) {
                q.orderBy(SpringOrders.toOrders((Props)table, finalSort));
            }
            if (fetcher != null) {
                return q.select(table.fetch(fetcher));
            }
            if (queryData.getSelectedPath() != null) {
                return q.select((Selection)((Expression)QueryExecutors.astSelection(table, queryData.getSelectedPath(), false)));
            }
            if (queryData.getAction() == Query.Action.COUNT) {
                return q.select((Selection)table.count());
            }
            if (queryData.getAction() == Query.Action.EXISTS) {
                return q.select((Selection)table.get(table.getImmutableType().getIdProp().getName()));
            }
            return q.select((Selection)table);
        });
        Class<?> returnType = queryMethod.getJavaMethod().getReturnType();
        switch (queryData.getAction()) {
            case FIND: {
                if (queryData.getLimit() != Integer.MAX_VALUE) {
                    query = query.limit(queryData.getLimit(), 0);
                }
                if (queryData.isDistinct()) {
                    query = query.distinct();
                }
                if (returnType == Page.class) {
                    if (pageable != null) {
                        int rowCount = query.count();
                        List entities = (List)query.limit(pageable.getPageSize(), (int)pageable.getOffset()).execute();
                        return new PageImpl(entities, pageable, (long)rowCount);
                    }
                    return new PageImpl((List)query.execute());
                }
                if (Iterable.class.isAssignableFrom(returnType)) {
                    return query.execute();
                }
                Optional<Object> entity = query.fetchOneOrNull();
                return returnType == Optional.class ? Optional.ofNullable(entity) : entity;
            }
            case COUNT: {
                long rowCount = (Long)query.fetchOne();
                if (returnType == Integer.TYPE) {
                    return (int)rowCount;
                }
                return rowCount;
            }
            case EXISTS: {
                return query.limit(1, 0).fetchOneOrNull() != null;
            }
        }
        return null;
    }

    private static org.babyfish.jimmer.sql.ast.Predicate astPredicate(Table<?> table, Predicate predicate, Object[] args) {
        org.babyfish.jimmer.sql.ast.Predicate[] subAstPredicates;
        List<Predicate> subPredicates;
        if (predicate == null) {
            return null;
        }
        if (predicate instanceof PropPredicate) {
            Selection<?> astSelection;
            PropPredicate propPredicate = (PropPredicate)predicate;
            switch (propPredicate.getOp()) {
                case NOT_IN: 
                case NOT_NULL: {
                    astSelection = QueryExecutors.astSelection(table, propPredicate.getPath(), true);
                    break;
                }
                default: {
                    astSelection = QueryExecutors.astSelection(table, propPredicate.getPath(), false);
                }
            }
            switch (propPredicate.getOp()) {
                case TRUE: {
                    return ((Expression)astSelection).eq((Object)true);
                }
                case FALSE: {
                    return ((Expression)astSelection).eq((Object)false);
                }
                case NULL: {
                    return astSelection instanceof Expression ? ((Expression)astSelection).isNull() : ((Table)astSelection).isNull();
                }
                case NOT_NULL: {
                    return astSelection instanceof Expression ? ((Expression)astSelection).isNotNull() : ((Table)astSelection).isNotNull();
                }
                case IN: {
                    Collection c = (Collection)args[propPredicate.getLogicParamIndex()];
                    return c == null ? null : ((Expression)astSelection).in(c);
                }
                case NOT_IN: {
                    Collection c = (Collection)args[propPredicate.getLogicParamIndex()];
                    return c == null ? null : ((Expression)astSelection).notIn(c);
                }
                case BETWEEN: {
                    astSelection = QueryExecutors.insensitive(propPredicate.isInsensitive(), astSelection);
                    Comparable min = (Comparable)QueryExecutors.insensitive(propPredicate.isInsensitive(), args[propPredicate.getLogicParamIndex()]);
                    Comparable max = (Comparable)QueryExecutors.insensitive(propPredicate.isInsensitive(), args[propPredicate.getLogicParamIndex2()]);
                    if (min != null && max != null) {
                        return ((ComparableExpression)astSelection).between(min, max);
                    }
                    if (min != null) {
                        return ((ComparableExpression)astSelection).ge(min);
                    }
                    if (max != null) {
                        return ((ComparableExpression)astSelection).le(max);
                    }
                    return null;
                }
                case NOT_BETWEEN: {
                    astSelection = QueryExecutors.insensitive(propPredicate.isInsensitive(), astSelection);
                    Comparable min = (Comparable)QueryExecutors.insensitive(propPredicate.isInsensitive(), args[propPredicate.getLogicParamIndex()]);
                    Comparable max = (Comparable)QueryExecutors.insensitive(propPredicate.isInsensitive(), args[propPredicate.getLogicParamIndex2()]);
                    if (min != null && max != null) {
                        return ((ComparableExpression)astSelection).notBetween(min, max);
                    }
                    if (min != null) {
                        return ((ComparableExpression)astSelection).lt(min);
                    }
                    if (max != null) {
                        return ((ComparableExpression)astSelection).gt(max);
                    }
                    return null;
                }
                case LIKE: {
                    String pattern = (String)args[propPredicate.getLogicParamIndex()];
                    return pattern == null || pattern.isEmpty() ? null : (propPredicate.isInsensitive() ? ((StringExpression)astSelection).ilike(pattern, propPredicate.getLikeMode()) : ((StringExpression)astSelection).like(pattern, propPredicate.getLikeMode()));
                }
                case NOT_LIKE: {
                    String pattern = (String)args[propPredicate.getLogicParamIndex()];
                    return pattern == null || pattern.isEmpty() ? null : (propPredicate.isInsensitive() ? ((StringExpression)astSelection).ilike(pattern, propPredicate.getLikeMode()).not() : ((StringExpression)astSelection).like(pattern, propPredicate.getLikeMode()).not());
                }
                case EQ: {
                    astSelection = QueryExecutors.insensitive(propPredicate.isInsensitive(), astSelection);
                    Object value = QueryExecutors.insensitive(propPredicate.isInsensitive(), args[propPredicate.getLogicParamIndex()]);
                    return value == null ? null : ((Expression)astSelection).eq(value);
                }
                case NE: {
                    astSelection = QueryExecutors.insensitive(propPredicate.isInsensitive(), astSelection);
                    Object value = QueryExecutors.insensitive(propPredicate.isInsensitive(), args[propPredicate.getLogicParamIndex()]);
                    return value == null ? null : ((Expression)astSelection).ne(value);
                }
                case LT: {
                    astSelection = QueryExecutors.insensitive(propPredicate.isInsensitive(), astSelection);
                    Comparable value = (Comparable)QueryExecutors.insensitive(propPredicate.isInsensitive(), args[propPredicate.getLogicParamIndex()]);
                    return value == null ? null : ((ComparableExpression)astSelection).lt(value);
                }
                case LE: {
                    astSelection = QueryExecutors.insensitive(propPredicate.isInsensitive(), astSelection);
                    Comparable value = (Comparable)QueryExecutors.insensitive(propPredicate.isInsensitive(), args[propPredicate.getLogicParamIndex()]);
                    return value == null ? null : ((ComparableExpression)astSelection).le(value);
                }
                case GT: {
                    astSelection = QueryExecutors.insensitive(propPredicate.isInsensitive(), astSelection);
                    Comparable value = (Comparable)QueryExecutors.insensitive(propPredicate.isInsensitive(), args[propPredicate.getLogicParamIndex()]);
                    return value == null ? null : ((ComparableExpression)astSelection).gt(value);
                }
                case GE: {
                    astSelection = QueryExecutors.insensitive(propPredicate.isInsensitive(), astSelection);
                    Comparable value = (Comparable)QueryExecutors.insensitive(propPredicate.isInsensitive(), args[propPredicate.getLogicParamIndex()]);
                    return value == null ? null : ((ComparableExpression)astSelection).ge(value);
                }
            }
        }
        if (predicate instanceof AndPredicate) {
            subPredicates = ((AndPredicate)predicate).getPredicates();
            subAstPredicates = new org.babyfish.jimmer.sql.ast.Predicate[subPredicates.size()];
            int index = 0;
            for (Predicate subPredicate : subPredicates) {
                subAstPredicates[index++] = QueryExecutors.astPredicate(table, subPredicate, args);
            }
            return org.babyfish.jimmer.sql.ast.Predicate.and((org.babyfish.jimmer.sql.ast.Predicate[])subAstPredicates);
        }
        if (predicate instanceof OrPredicate) {
            subPredicates = ((OrPredicate)predicate).getPredicates();
            subAstPredicates = new org.babyfish.jimmer.sql.ast.Predicate[subPredicates.size()];
            int index = 0;
            for (Predicate subPredicate : subPredicates) {
                subAstPredicates[index++] = QueryExecutors.astPredicate(table, subPredicate, args);
            }
            return org.babyfish.jimmer.sql.ast.Predicate.or((org.babyfish.jimmer.sql.ast.Predicate[])subAstPredicates);
        }
        throw new AssertionError((Object)("Internal bug, unexpected prop predicate " + predicate));
    }

    private static Selection<?> astSelection(Table<?> table, Path path, boolean outerJoin) {
        Table propExpr = null;
        for (ImmutableProp prop : path.getProps()) {
            if (prop.isAssociation(TargetLevel.PERSISTENT)) {
                table = table.join(prop.getName(), outerJoin ? JoinType.LEFT : JoinType.INNER);
                continue;
            }
            if (propExpr instanceof PropExpression.Embedded) {
                propExpr = (PropExpression)((PropExpression.Embedded)propExpr).get(prop.getName());
                continue;
            }
            propExpr = (PropExpression)table.get(prop.getName());
        }
        return propExpr != null ? propExpr : table;
    }

    private static Expression<?> insensitive(boolean apply, Selection<?> astExpression) {
        if (apply) {
            return ((StringExpression)astExpression).lower();
        }
        return (Expression)astExpression;
    }

    private static Object insensitive(boolean apply, Object arg) {
        if (apply && arg != null) {
            return ((String)arg).toLowerCase();
        }
        return arg;
    }
}

