/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.parser;

import java.lang.reflect.Method;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.repository.parser.Context;
import org.babyfish.jimmer.spring.repository.parser.Query;
import org.babyfish.jimmer.spring.repository.parser.QueryMethodParser;

public class QueryMethod {
    private final Method javaMethod;
    private final Query query;
    private final int pageableParamIndex;
    private final int sortParamIndex;
    private final int fetcherParamIndex;

    public QueryMethod(Method javaMethod, Query query, int pageableParamIndex, int sortParamIndex, int fetcherParamIndex) {
        this.javaMethod = javaMethod;
        this.query = query;
        this.pageableParamIndex = pageableParamIndex;
        this.sortParamIndex = sortParamIndex;
        this.fetcherParamIndex = fetcherParamIndex;
    }

    public static QueryMethod of(Context ctx, ImmutableType type, Method method) {
        return QueryMethodParser.parse(ctx, type, method);
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public Query getQuery() {
        return this.query;
    }

    public int getPageableParamIndex() {
        return this.pageableParamIndex;
    }

    public int getSortParamIndex() {
        return this.sortParamIndex;
    }

    public int getFetcherParamIndex() {
        return this.fetcherParamIndex;
    }

    public String toString() {
        return "QueryMethod{javaMethod=" + this.javaMethod + ", query=" + this.query + ", pageableParamIndex=" + this.pageableParamIndex + ", sortParamIndex=" + this.sortParamIndex + ", fetcherParamIndex=" + this.fetcherParamIndex + '}';
    }
}

