/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg;

import graphql.GraphQL;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeRuntimeWiring;
import java.util.Collection;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.meta.impl.TypedPropImpl;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.kt.KSqlClient;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.dataloader.DataLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.graphql.execution.BatchLoaderRegistry;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import reactor.core.publisher.Mono;

@ConditionalOnClass(value={GraphQL.class, GraphQlSource.class})
public class JimmerSpringGraphQLAutoConfiguration {
    public JimmerSpringGraphQLAutoConfiguration(BatchLoaderRegistry registry, @Autowired(required=false) JSqlClient jSqlClient, @Autowired(required=false) KSqlClient kSqlClient) {
        JSqlClientImplementor sqlClient = JimmerSpringGraphQLAutoConfiguration.sqlClient(jSqlClient, kSqlClient);
        for (ImmutableType type : sqlClient.getEntityManager().getAllTypes(sqlClient.getMicroServiceName())) {
            if (!type.isEntity()) continue;
            for (ImmutableProp prop : type.getProps().values()) {
                if (prop.isReference(TargetLevel.ENTITY)) {
                    registry.forName(prop.toString()).registerMappedBatchLoader((sources, env) -> Mono.just((Object)sqlClient.getLoaders().reference((TypedProp.Reference)new TypedPropImpl.Reference(prop)).batchLoad((Collection)sources)));
                    continue;
                }
                if (prop.isReferenceList(TargetLevel.ENTITY)) {
                    registry.forName(prop.toString()).registerMappedBatchLoader((sources, env) -> Mono.just((Object)sqlClient.getLoaders().list((TypedProp.ReferenceList)new TypedPropImpl.ReferenceList(prop)).batchLoad((Collection)sources)));
                    continue;
                }
                if (!prop.hasTransientResolver()) continue;
                registry.forName(prop.toString()).registerMappedBatchLoader((sources, env) -> Mono.just((Object)sqlClient.getLoaders().value((TypedProp.Scalar)new TypedPropImpl.Scalar(prop)).batchLoad((Collection)sources)));
            }
        }
    }

    @Bean
    public RuntimeWiringConfigurer jimmerRuntimeWiringConfigurer(@Autowired(required=false) JSqlClient jSqlClient, @Autowired(required=false) KSqlClient kSqlClient) {
        JSqlClientImplementor sqlClient = JimmerSpringGraphQLAutoConfiguration.sqlClient(jSqlClient, kSqlClient);
        return wiringBuilder -> JimmerSpringGraphQLAutoConfiguration.registerJimmerDataFetchers(wiringBuilder, sqlClient);
    }

    private static void registerJimmerDataFetchers(RuntimeWiring.Builder wiringBuilder, JSqlClientImplementor sqlClient) {
        for (ImmutableType type : sqlClient.getEntityManager().getAllTypes(sqlClient.getMicroServiceName())) {
            if (!type.isEntity()) continue;
            TypeRuntimeWiring.Builder typeBuilder = TypeRuntimeWiring.newTypeWiring((String)type.getJavaClass().getSimpleName());
            for (ImmutableProp prop : type.getProps().values()) {
                if (prop.isAssociation(TargetLevel.ENTITY) || prop.hasTransientResolver()) {
                    typeBuilder.dataFetcher(prop.getName(), (DataFetcher)new JimmerComplexFetcher(prop));
                    continue;
                }
                typeBuilder.dataFetcher(prop.getName(), (DataFetcher)new JimmerSimpleFetcher(prop.getId()));
            }
            wiringBuilder.type(typeBuilder);
        }
    }

    private static JSqlClientImplementor sqlClient(JSqlClient jSqlClient, KSqlClient kSqlClient) {
        return (JSqlClientImplementor)(jSqlClient != null ? jSqlClient : kSqlClient.getJavaClient());
    }

    private static class JimmerComplexFetcher
    implements DataFetcher<Object> {
        private final ImmutableProp prop;

        JimmerComplexFetcher(ImmutableProp prop) {
            this.prop = prop;
        }

        public Object get(DataFetchingEnvironment env) throws Exception {
            DataLoader dataLoader = env.getDataLoaderRegistry().getDataLoader(this.prop.toString());
            if (dataLoader == null) {
                throw new IllegalStateException("No DataLoader for key '" + this.prop + "'");
            }
            return dataLoader.load(env.getSource());
        }
    }

    private static class JimmerSimpleFetcher
    implements DataFetcher<Object> {
        private final int propId;

        JimmerSimpleFetcher(int propId) {
            this.propId = propId;
        }

        public Object get(DataFetchingEnvironment environment) throws Exception {
            ImmutableSpi spi = (ImmutableSpi)environment.getSource();
            return spi.__get(this.propId);
        }
    }
}

