/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.spi.AbstractRemoteHashBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;

public class RedisHashBinder<K, V>
extends AbstractRemoteHashBinder<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisHashBinder.class);
    private final RedisOperations<String, byte[]> operations;

    public RedisHashBinder(RedisOperations<String, byte[]> operations, ObjectMapper objectMapper, ImmutableType type, Duration duration) {
        super(objectMapper, type, null, duration, 30);
        this.operations = operations;
    }

    public RedisHashBinder(RedisOperations<String, byte[]> operations, ObjectMapper objectMapper, ImmutableProp prop, Duration duration) {
        super(objectMapper, null, prop, duration, 30);
        this.operations = operations;
    }

    protected List<byte[]> read(final Collection<String> keys, final String hashKey) {
        return this.operations.executePipelined((SessionCallback)new SessionCallback<Void>(){

            public <XK, XV> Void execute(RedisOperations<XK, XV> pops) throws DataAccessException {
                RedisOperations<XK, XV> pipelinedOps = pops;
                for (String key : keys) {
                    pipelinedOps.opsForHash().get((Object)key, (Object)hashKey);
                }
                return null;
            }
        });
    }

    protected void write(final Map<String, byte[]> map, final String hashKey) {
        this.operations.executePipelined((SessionCallback)new SessionCallback<Void>(){

            public <XK, XV> Void execute(RedisOperations<XK, XV> pops) throws DataAccessException {
                RedisOperations<XK, XV> pipelinedOps = pops;
                for (Map.Entry e : map.entrySet()) {
                    pipelinedOps.opsForHash().put((Object)((String)e.getKey()), (Object)hashKey, e.getValue());
                    pipelinedOps.expire((Object)((String)e.getKey()), RedisHashBinder.this.nextExpireMillis(), TimeUnit.MILLISECONDS);
                }
                return null;
            }
        });
    }

    protected void delete(Collection<String> keys) {
        LOGGER.info("Delete data from redis: {}", keys);
        this.operations.delete(keys);
    }

    protected String reason() {
        return "redis";
    }
}

