/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.client;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.client.meta.Metadata;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

public class JakartaMetadataFactoryBean
implements FactoryBean<Metadata> {
    private static final Set<String> IGNORED_CLASS_NAMES;
    private final ApplicationContext ctx;
    private final ParameterNameDiscoverer parameterNameDiscoverer;

    public JakartaMetadataFactoryBean(ApplicationContext ctx, ParameterNameDiscoverer parameterNameDiscoverer) {
        this.ctx = ctx;
        this.parameterNameDiscoverer = parameterNameDiscoverer != null ? parameterNameDiscoverer : new DefaultParameterNameDiscoverer();
    }

    public Class<?> getObjectType() {
        return Metadata.class;
    }

    public Metadata getObject() {
        List packageNames = AutoConfigurationPackages.get((BeanFactory)this.ctx);
        ArrayList<Class> serviceTypes = new ArrayList<Class>();
        for (Object bean : this.ctx.getBeansWithAnnotation(RestController.class).values()) {
            boolean shouldBeParsed = false;
            for (String packageName : packageNames) {
                if (!bean.getClass().getName().startsWith(packageName + '.')) continue;
                shouldBeParsed = true;
                break;
            }
            if (!shouldBeParsed) continue;
            serviceTypes.add(AopUtils.getTargetClass(bean));
        }
        return Metadata.newBuilder().addServiceTypes(serviceTypes).setOperationParser(new Metadata.OperationParser(){

            public Tuple2<String, Operation.HttpMethod> http(AnnotatedElement annotatedElement) {
                RequestMapping requestMapping;
                if (annotatedElement instanceof Method) {
                    GetMapping getMapping = annotatedElement.getAnnotation(GetMapping.class);
                    if (getMapping != null) {
                        return new Tuple2((Object)JakartaMetadataFactoryBean.text(getMapping.value(), getMapping.path()), (Object)Operation.HttpMethod.GET);
                    }
                    PostMapping postMapping = annotatedElement.getAnnotation(PostMapping.class);
                    if (postMapping != null) {
                        return new Tuple2((Object)JakartaMetadataFactoryBean.text(postMapping.value(), postMapping.path()), (Object)Operation.HttpMethod.POST);
                    }
                    PutMapping putMapping = annotatedElement.getAnnotation(PutMapping.class);
                    if (putMapping != null) {
                        return new Tuple2((Object)JakartaMetadataFactoryBean.text(putMapping.value(), putMapping.path()), (Object)Operation.HttpMethod.PUT);
                    }
                    DeleteMapping deleteMapping = annotatedElement.getAnnotation(DeleteMapping.class);
                    if (deleteMapping != null) {
                        return new Tuple2((Object)JakartaMetadataFactoryBean.text(deleteMapping.value(), deleteMapping.path()), (Object)Operation.HttpMethod.DELETE);
                    }
                }
                if ((requestMapping = annotatedElement.getAnnotation(RequestMapping.class)) != null) {
                    return new Tuple2((Object)JakartaMetadataFactoryBean.text(requestMapping.value(), requestMapping.path()), requestMapping.method().length != 0 ? Operation.HttpMethod.valueOf((String)requestMapping.method()[0].name()) : null);
                }
                return null;
            }

            public String[] getParameterNames(Method method) {
                return JakartaMetadataFactoryBean.this.parameterNameDiscoverer.getParameterNames(method);
            }
        }).setParameterParser(new Metadata.ParameterParser(){

            @Nullable
            public Tuple2<String, Boolean> requestParamNameAndNullable(Parameter javaParameter) {
                RequestParam requestParam = javaParameter.getAnnotation(RequestParam.class);
                if (requestParam == null) {
                    return null;
                }
                return new Tuple2((Object)JakartaMetadataFactoryBean.notEmpty(requestParam.value(), requestParam.name()), (Object)(!requestParam.required() ? 1 : 0));
            }

            @Nullable
            public String pathVariableName(Parameter javaParameter) {
                PathVariable pathVariable = javaParameter.getAnnotation(PathVariable.class);
                if (pathVariable == null) {
                    return null;
                }
                return JakartaMetadataFactoryBean.notEmpty(pathVariable.value(), pathVariable.name());
            }

            public boolean isRequestBody(Parameter javaParameter) {
                return javaParameter.isAnnotationPresent(RequestBody.class);
            }

            public boolean shouldBeIgnored(Parameter javaParameter) {
                return IGNORED_CLASS_NAMES.contains(javaParameter.getType().getName());
            }
        }).build();
    }

    private static String text(String[] a, String[] b) {
        for (String value : a) {
            if (value.isEmpty()) continue;
            return value;
        }
        for (String path : b) {
            if (path.isEmpty()) continue;
            return path;
        }
        return "";
    }

    private static String notEmpty(String a, String b) {
        if (!a.isEmpty()) {
            return a;
        }
        if (!b.isEmpty()) {
            return b;
        }
        return "";
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(HttpServletRequest.class.getName());
        set.add(ServletRequest.class.getName());
        set.add(HttpServletResponse.class.getName());
        set.add(ServletResponse.class.getName());
        set.add(MultipartFile.class.getName());
        set.add(Principal.class.getName());
        IGNORED_CLASS_NAMES = set;
    }
}

