/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.babyfish.jimmer.client.meta.Metadata;
import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.spring.cfg.JimmerProperties;
import org.babyfish.jimmer.spring.cfg.MetadataCondition;
import org.babyfish.jimmer.spring.cfg.MicroServiceCondition;
import org.babyfish.jimmer.spring.cfg.SqlClientConfig;
import org.babyfish.jimmer.spring.client.JavaFeignController;
import org.babyfish.jimmer.spring.client.MetadataFactoryBean;
import org.babyfish.jimmer.spring.client.TypeScriptController;
import org.babyfish.jimmer.spring.cloud.MicroServiceExporterController;
import org.babyfish.jimmer.spring.repository.config.JimmerRepositoriesConfig;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.kt.KSqlClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;
import org.springframework.core.ParameterNameDiscoverer;

@AutoConfiguration(after={DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={JimmerProperties.class})
@Import(value={SqlClientConfig.class, JimmerRepositoriesConfig.class})
public class JimmerAutoConfiguration {
    @ConditionalOnMissingBean(value={ImmutableModule.class})
    @Bean
    public ImmutableModule immutableModule() {
        return new ImmutableModule();
    }

    @ConditionalOnProperty(value={"jimmer.client.ts.path"})
    @ConditionalOnMissingBean(value={TypeScriptController.class})
    @Bean
    public TypeScriptController typeScriptController(Metadata metadata, JimmerProperties properties) {
        return new TypeScriptController(metadata, properties);
    }

    @ConditionalOnProperty(value={"jimmer.client.java-feign.path"})
    @ConditionalOnMissingBean(value={JavaFeignController.class})
    @Bean
    public JavaFeignController javaFeignController(Metadata metadata, JimmerProperties properties) {
        return new JavaFeignController(metadata, properties);
    }

    @Conditional(value={MetadataCondition.class})
    @ConditionalOnMissingBean(value={Metadata.class})
    @Bean
    public MetadataFactoryBean metadataFactoryBean(ApplicationContext ctx, @Autowired(required=false) ParameterNameDiscoverer parameterNameDiscoverer) {
        return new MetadataFactoryBean(ctx, parameterNameDiscoverer);
    }

    @Conditional(value={MicroServiceCondition.class})
    @ConditionalOnMissingBean(value={MicroServiceExporterController.class})
    @Bean
    public MicroServiceExporterController microServiceExporterController(@Autowired(required=false) JSqlClient jSqlClient, @Autowired(required=false) KSqlClient kSqlClient, ObjectMapper objectMapper) {
        return new MicroServiceExporterController(jSqlClient != null ? jSqlClient : kSqlClient.getJavaClient(), objectMapper);
    }
}

