/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cloud;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.spring.cloud.MicroServiceExporterAgent;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.compiler.FetcherCompiler;
import org.babyfish.jimmer.sql.runtime.MicroServiceExporter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MicroServiceExporterController
implements MicroServiceExporterAgent {
    private final MicroServiceExporter exporter;
    private final ObjectMapper mapper;

    public MicroServiceExporterController(JSqlClient sqlClient, ObjectMapper mapper) {
        this.exporter = new MicroServiceExporter(sqlClient);
        this.mapper = mapper;
    }

    @Override
    @GetMapping(value={"/jimmerMicroServiceBridge/byIds"})
    public void findByIds(@RequestParam(value="ids") String idArrStr, @RequestParam(value="fetcher") String fetcherStr, HttpServletResponse response) throws JsonProcessingException, IOException {
        Fetcher fetcher = FetcherCompiler.compile((String)fetcherStr);
        Class idType = fetcher.getImmutableType().getIdProp().getElementClass();
        List ids = (List)this.mapper.readValue(idArrStr, (JavaType)CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe((Class)Classes.boxTypeOf((Class)idType))));
        List data = this.exporter.findByIds((Collection)ids, fetcher);
        response.setContentType("application/json");
        try (ServletOutputStream out = response.getOutputStream();){
            this.mapper.writeValue((OutputStream)out, (Object)data);
        }
    }

    @Override
    @GetMapping(value={"/jimmerMicroServiceBridge/byAssociatedIds"})
    public void findByAssociatedIds(@RequestParam(value="prop") String prop, @RequestParam(value="targetIds") String targetIdArrStr, @RequestParam(value="fetcher") String fetcherStr, HttpServletResponse response) throws Exception {
        Fetcher fetcher = FetcherCompiler.compile((String)fetcherStr);
        ImmutableProp immutableProp = fetcher.getImmutableType().getProp(prop);
        Class targetIdType = immutableProp.getTargetType().getIdProp().getElementClass();
        List targetIds = (List)this.mapper.readValue(targetIdArrStr, (JavaType)CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe((Class)Classes.boxTypeOf((Class)targetIdType))));
        List data = this.exporter.findByAssociatedIds(immutableProp, (Collection)targetIds, fetcher);
        response.setContentType("application/json");
        try (ServletOutputStream out = response.getOutputStream();){
            this.mapper.writeValue((OutputStream)out, (Object)data);
        }
    }
}

