/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cloud;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.util.Collection;
import java.util.List;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.spring.cloud.FindByAssociatedIdsRequest;
import org.babyfish.jimmer.spring.cloud.FindByIdsRequest;
import org.babyfish.jimmer.spring.cloud.MicroServiceExporterAgent;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.compiler.FetcherCompiler;
import org.babyfish.jimmer.sql.runtime.MicroServiceExporter;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MicroServiceExporterController
implements MicroServiceExporterAgent {
    private final MicroServiceExporter exporter;
    private final ObjectMapper mapper;

    public MicroServiceExporterController(JSqlClient sqlClient, ObjectMapper mapper) {
        this.exporter = new MicroServiceExporter(sqlClient);
        this.mapper = mapper;
    }

    @Override
    @PostMapping(value={"/jimmerMicroServiceBridge/byIds"}, produces={"application/json"})
    @ResponseBody
    public List<ImmutableSpi> findByIds(@RequestBody FindByIdsRequest request) throws JsonProcessingException {
        Fetcher fetcher = FetcherCompiler.compile((String)request.getFetcherStr());
        Class idType = fetcher.getImmutableType().getIdProp().getElementClass();
        List ids = (List)this.mapper.readValue(request.getIdArrStr(), (JavaType)CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe((Class)Classes.boxTypeOf((Class)idType))));
        return this.exporter.findByIds((Collection)ids, fetcher);
    }

    @Override
    @PostMapping(value={"/jimmerMicroServiceBridge/byAssociatedIds"}, produces={"application/json"})
    @ResponseBody
    public List<Tuple2<Object, ImmutableSpi>> findByAssociatedIds(@RequestBody FindByAssociatedIdsRequest request) throws JsonProcessingException {
        Fetcher fetcher = FetcherCompiler.compile((String)request.getFetcherStr());
        ImmutableProp immutableProp = fetcher.getImmutableType().getProp(request.getProp());
        Class targetIdType = immutableProp.getTargetType().getIdProp().getElementClass();
        List targetIds = (List)this.mapper.readValue(request.getTargetIdArrStr(), (JavaType)CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe((Class)Classes.boxTypeOf((Class)targetIdType))));
        return this.exporter.findByAssociatedIds(immutableProp, (Collection)targetIds, fetcher);
    }
}

