/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cloud;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.MicroServiceExchange;
import org.springframework.web.client.RestTemplate;

public class SpringCloudExchange
implements MicroServiceExchange {
    private final RestTemplate restTemplate;
    private final ObjectMapper mapper;

    public SpringCloudExchange(RestTemplate restTemplate, ObjectMapper mapper) {
        this.restTemplate = restTemplate;
        this.mapper = mapper;
    }

    public List<ImmutableSpi> findByIds(String microServiceName, Collection<?> ids, Fetcher<?> fetcher) throws JsonProcessingException {
        return (List)this.restTemplate.getForObject("http://{microServiceName}/jimmerMicroServiceBridge/byIds?ids={ids}&fetcher={fetcher}", List.class, new Object[]{microServiceName, this.mapper.writeValueAsString(ids), fetcher.toString(true)});
    }

    public List<Tuple2<Object, ImmutableSpi>> findByAssociatedIds(String microServiceName, ImmutableProp prop, Collection<?> targetIds, Fetcher<?> fetcher) throws JsonProcessingException {
        return (List)this.restTemplate.getForObject("http://{microServiceName}/jimmerMicroServiceBridge/byAssociatedIds?prop={prop}&targetIds={targetIds}&fetcher={fetcher}", List.class, new Object[]{microServiceName, prop.getName(), this.mapper.writeValueAsString(targetIds), fetcher.toString(true)});
    }
}

