/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cloud;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.util.Collection;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.spring.cloud.MicroServiceExporterAgent;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.compiler.FetcherCompiler;
import org.babyfish.jimmer.sql.runtime.MicroServiceExporter;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jimmerMicroServiceBridge"})
public class MicroServiceExporterController
implements MicroServiceExporterAgent {
    private final MicroServiceExporter exporter;
    private final ObjectMapper mapper;

    public MicroServiceExporterController(JSqlClient sqlClient, ObjectMapper mapper) {
        this.exporter = new MicroServiceExporter(sqlClient);
        this.mapper = mapper;
    }

    @Override
    @GetMapping(value={"/byIds"})
    public List<ImmutableSpi> findByIds(@RequestParam(value="ids") String idArrStr, @RequestParam(value="fetcher") String fetcherStr) throws JsonProcessingException {
        Fetcher fetcher = FetcherCompiler.compile((String)fetcherStr);
        Class idType = fetcher.getImmutableType().getIdProp().getElementClass();
        List ids = (List)this.mapper.readValue(idArrStr, (JavaType)CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe((Class)idType)));
        return this.exporter.findByIds((Collection)ids, fetcher);
    }

    @Override
    @GetMapping(value={"/byAssociatedIds"})
    public List<Tuple2<Object, ImmutableSpi>> findByAssociatedIds(@RequestParam(value="prop") String prop, @RequestParam(value="targetIds") String targetIdsArrStr, @RequestParam(value="fetcher") String fetcherStr) throws JsonProcessingException {
        Fetcher fetcher = FetcherCompiler.compile((String)fetcherStr);
        ImmutableProp immutableProp = fetcher.getImmutableType().getProp(prop);
        Class targetIdType = immutableProp.getTargetType().getIdProp().getElementClass();
        List targetIds = (List)this.mapper.readValue(targetIdsArrStr, (JavaType)CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe((Class)targetIdType)));
        return this.exporter.findByAssociatedIds(immutableProp, (Collection)targetIds, fetcher);
    }
}

