/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.bytecode;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.babyfish.jimmer.impl.asm.Type;
import org.babyfish.jimmer.spring.repository.bytecode.ClassCodeWriter;
import org.babyfish.jimmer.spring.repository.bytecode.MethodCodeWriter;

public class KotlinMethodCodeWriter
extends MethodCodeWriter {
    protected KotlinMethodCodeWriter(ClassCodeWriter parent, Method method, String id) {
        super(parent, method, id);
    }

    @Override
    protected void visitLoadJSqlClient() {
        this.mv.visitVarInsn(25, 0);
        this.mv.visitMethodInsn(182, K_REPOSITORY_IMPL, "getSql", "()" + K_SQL_CLIENT_DESCRIPTOR, false);
        this.mv.visitMethodInsn(185, K_SQL_CLIENT_INTERNAL_NAME, "getJavaClient", "()" + J_SQL_CLIENT_DESCRIPTOR, true);
    }

    @Override
    public void write() {
        if (this.method.isDefault()) {
            return;
        }
        Method defaultMethod = this.getDefaultImplMethod();
        if (defaultMethod != null) {
            this.writeDefaultInvocation(defaultMethod);
            return;
        }
        super.write();
    }

    private void writeDefaultInvocation(Method defaultMethod) {
        this.mv = this.parent.getClassVisitor().visitMethod(1, this.method.getName(), Type.getMethodDescriptor((Method)this.method), null, null);
        this.mv.visitCode();
        MethodCodeWriter.VarLoader loader = new MethodCodeWriter.VarLoader(this, 0);
        for (Class<?> type : defaultMethod.getParameterTypes()) {
            loader.load(type);
        }
        this.mv.visitMethodInsn(184, Type.getInternalName(defaultMethod.getDeclaringClass()), this.method.getName(), Type.getMethodDescriptor((Method)defaultMethod), false);
        this.visitReturn(this.method.getReturnType());
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    @Override
    protected Method onGetDefaultImplMethod() {
        Method defaultImplMethod;
        Class repositoryInterface = this.parent.getMetadata().getRepositoryInterface();
        Class<?> defaultImpl = null;
        for (Class<?> nestedClass : repositoryInterface.getClasses()) {
            if (!nestedClass.getSimpleName().equals("DefaultImpls")) continue;
            defaultImpl = nestedClass;
            break;
        }
        if (defaultImpl == null) {
            return null;
        }
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Class[] newParameterTypes = new Class[parameterTypes.length + 1];
        System.arraycopy(parameterTypes, 0, newParameterTypes, 1, parameterTypes.length);
        newParameterTypes[0] = repositoryInterface;
        try {
            defaultImplMethod = defaultImpl.getMethod(this.method.getName(), newParameterTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        if (Modifier.isStatic(defaultImplMethod.getModifiers())) {
            return defaultImplMethod;
        }
        return null;
    }
}

