/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.annotation.AliasFor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.PagingAndSortingRepository;

@NoRepositoryBean
public interface JRepository<E, ID>
extends PagingAndSortingRepository<E, ID> {
    public JSqlClient sql();

    public ImmutableType type();

    public Class<E> entityType();

    public Pager pager(Pageable var1);

    public Pager pager(int var1, int var2);

    public E findNullable(ID var1);

    public E findNullable(ID var1, Fetcher<E> var2);

    @NotNull
    default public Optional<E> findById(ID id) {
        return Optional.ofNullable(this.findNullable(id));
    }

    default public Optional<E> findById(ID id, Fetcher<E> fetcher) {
        return Optional.ofNullable(this.findNullable(id, fetcher));
    }

    @AliasFor(value="findAllById")
    public List<E> findByIds(Iterable<ID> var1);

    @AliasFor(value="findByIds")
    @NotNull
    default public Iterable<E> findAllById(@NotNull Iterable<ID> ids) {
        return this.findByIds(ids);
    }

    public List<E> findByIds(Iterable<ID> var1, Fetcher<E> var2);

    public Map<ID, E> findMapByIds(Iterable<ID> var1);

    public Map<ID, E> findMapByIds(Iterable<ID> var1, Fetcher<E> var2);

    @NotNull
    public List<E> findAll();

    public List<E> findAll(TypedProp.Scalar<?, ?> ... var1);

    public List<E> findAll(Fetcher<E> var1, TypedProp.Scalar<?, ?> ... var2);

    @NotNull
    public List<E> findAll(@NotNull Sort var1);

    public List<E> findAll(Fetcher<E> var1, Sort var2);

    public Page<E> findAll(int var1, int var2);

    public Page<E> findAll(int var1, int var2, Fetcher<E> var3);

    public Page<E> findAll(int var1, int var2, TypedProp.Scalar<?, ?> ... var3);

    public Page<E> findAll(int var1, int var2, Fetcher<E> var3, TypedProp.Scalar<?, ?> ... var4);

    public Page<E> findAll(int var1, int var2, Sort var3);

    public Page<E> findAll(int var1, int var2, Fetcher<E> var3, Sort var4);

    @NotNull
    public Page<E> findAll(@NotNull Pageable var1);

    public Page<E> findAll(Pageable var1, Fetcher<E> var2);

    default public boolean existsById(ID id) {
        return this.findNullable(id) != null;
    }

    public long count();

    @NotNull
    default public E insert(@NotNull Input<E> input) {
        return (E)this.save(input.toEntity(), SaveMode.INSERT_ONLY).getModifiedEntity();
    }

    @NotNull
    default public E insert(@NotNull E entity) {
        return (E)this.save(entity, SaveMode.INSERT_ONLY).getModifiedEntity();
    }

    @NotNull
    default public E update(@NotNull Input<E> input) {
        return (E)this.save(input.toEntity(), SaveMode.UPDATE_ONLY).getModifiedEntity();
    }

    @NotNull
    default public E update(@NotNull E entity) {
        return (E)this.save(entity, SaveMode.UPDATE_ONLY).getModifiedEntity();
    }

    @NotNull
    default public E save(@NotNull Input<E> input) {
        return (E)this.save(input.toEntity(), SaveMode.UPSERT).getModifiedEntity();
    }

    @NotNull
    default public <S extends E> S save(@NotNull S entity) {
        return (S)this.save(entity, SaveMode.UPSERT).getModifiedEntity();
    }

    @NotNull
    default public SimpleSaveResult<E> save(@NotNull Input<E> input, SaveMode mode) {
        return this.save(input.toEntity(), mode);
    }

    @NotNull
    public <S extends E> SimpleSaveResult<S> save(@NotNull S var1, SaveMode var2);

    @NotNull
    public SimpleEntitySaveCommand<E> saveCommand(@NotNull Input<E> var1);

    @NotNull
    public <S extends E> SimpleEntitySaveCommand<S> saveCommand(@NotNull S var1);

    @NotNull
    default public <S extends E> Iterable<S> saveAll(@NotNull Iterable<S> entities) {
        return this.saveAll(entities, SaveMode.UPSERT).getSimpleResults().stream().map(SimpleSaveResult::getModifiedEntity).collect(Collectors.toList());
    }

    @NotNull
    public <S extends E> BatchSaveResult<S> saveAll(@NotNull Iterable<S> var1, SaveMode var2);

    @NotNull
    public <S extends E> BatchEntitySaveCommand<S> saveAllCommand(@NotNull Iterable<S> var1);

    default public void delete(@NotNull E entity) {
        this.delete(entity, DeleteMode.AUTO);
    }

    public int delete(@NotNull E var1, DeleteMode var2);

    default public void deleteAll(@NotNull Iterable<? extends E> entities) {
        this.deleteAll(entities, DeleteMode.AUTO);
    }

    public int deleteAll(@NotNull Iterable<? extends E> var1, DeleteMode var2);

    default public void deleteById(@NotNull ID id) {
        this.deleteById(id, DeleteMode.AUTO);
    }

    public int deleteById(@NotNull ID var1, DeleteMode var2);

    @AliasFor(value="deleteAllById")
    default public void deleteByIds(Iterable<? extends ID> ids) {
        this.deleteByIds(ids, DeleteMode.AUTO);
    }

    @AliasFor(value="deleteByIds")
    default public void deleteAllById(@NotNull Iterable<? extends ID> ids) {
        this.deleteByIds(ids, DeleteMode.AUTO);
    }

    @AliasFor(value="deleteAllById")
    public int deleteByIds(Iterable<? extends ID> var1, DeleteMode var2);

    public void deleteAll();

    public static interface Pager {
        public <T> Page<T> execute(ConfigurableRootQuery<?, T> var1);
    }
}

