/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.support;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.spring.repository.JRepository;
import org.babyfish.jimmer.spring.repository.SpringOrders;
import org.babyfish.jimmer.spring.repository.support.Utils;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.mutation.Mutations;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.PagingQueries;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public class JRepositoryImpl<E, ID>
implements JRepository<E, ID> {
    private static final TypedProp.Scalar<?, ?>[] EMPTY_SORTED_PROPS = new TypedProp.Scalar[0];
    protected final JSqlClientImplementor sqlClient;
    protected final Class<E> entityType;
    protected final ImmutableType immutableType;

    protected JRepositoryImpl(JSqlClient sqlClient) {
        this(sqlClient, null);
    }

    public JRepositoryImpl(JSqlClient sqlClient, Class<E> entityType) {
        this.sqlClient = Utils.validateSqlClient(sqlClient);
        if (entityType != null) {
            this.entityType = entityType;
        } else {
            Class[] typeArguments = GenericTypeResolver.resolveTypeArguments(this.getClass(), JRepository.class);
            if (typeArguments == null) {
                throw new IllegalArgumentException("The class \"" + this.getClass() + "\" does not explicitly specify the type arguments of \"" + JRepository.class.getName() + "\" so that the entityType must be specified");
            }
            this.entityType = entityType = typeArguments[0];
        }
        this.immutableType = ImmutableType.get(entityType);
        if (!this.immutableType.isEntity()) {
            throw new IllegalArgumentException("\"" + entityType + "\" is not entity type decorated by @" + Entity.class.getName());
        }
    }

    @Override
    public JSqlClient sql() {
        return this.sqlClient;
    }

    @Override
    public ImmutableType type() {
        return this.immutableType;
    }

    @Override
    public Class<E> entityType() {
        return this.entityType;
    }

    @Override
    public JRepository.Pager pager(Pageable pageable) {
        return new PagerImpl(pageable.getPageNumber(), pageable.getPageSize());
    }

    @Override
    public JRepository.Pager pager(int pageIndex, int pageSize) {
        return new PagerImpl(pageIndex, pageSize);
    }

    @Override
    public E findNullable(ID id) {
        return (E)this.sqlClient.getEntities().findById(this.entityType, id);
    }

    @Override
    public E findNullable(ID id, Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.findNullable(id);
        }
        return (E)this.sqlClient.getEntities().findById(fetcher, id);
    }

    @Override
    public List<E> findByIds(Iterable<ID> ids) {
        return this.sqlClient.getEntities().findByIds(this.entityType, Utils.toCollection(ids));
    }

    @Override
    public List<E> findByIds(Iterable<ID> ids, Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.findByIds(ids);
        }
        return this.sqlClient.getEntities().findByIds(fetcher, Utils.toCollection(ids));
    }

    @Override
    public Map<ID, E> findMapByIds(Iterable<ID> ids) {
        return this.sqlClient.getEntities().findMapByIds(this.entityType, Utils.toCollection(ids));
    }

    @Override
    public Map<ID, E> findMapByIds(Iterable<ID> ids, Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.findMapByIds(ids);
        }
        return this.sqlClient.getEntities().findMapByIds(fetcher, Utils.toCollection(ids));
    }

    @Override
    @NotNull
    public List<E> findAll() {
        return this.sqlClient.getEntities().findAll(this.entityType, new TypedProp.Scalar[0]);
    }

    @Override
    public List<E> findAll(TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.sqlClient.getEntities().findAll(this.entityType, sortedProps);
    }

    @Override
    public List<E> findAll(Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        if (fetcher == null) {
            return this.findAll(sortedProps);
        }
        return this.sqlClient.getEntities().findAll(fetcher, sortedProps);
    }

    @Override
    @NotNull
    public List<E> findAll(@NotNull Sort sort) {
        return this.findAll(null, sort);
    }

    @Override
    public List<E> findAll(Fetcher<E> fetcher, Sort sort) {
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, this.immutableType, ExecutionPurpose.QUERY, false);
        Table table = query.getTable();
        query.orderBy(SpringOrders.toOrders((Props)table, sort));
        return (List)query.select(table.fetch(fetcher)).execute();
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize) {
        return this.findAll(pageIndex, pageSize, (Fetcher<E>)null, EMPTY_SORTED_PROPS);
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher) {
        return this.findAll(pageIndex, pageSize, fetcher, EMPTY_SORTED_PROPS);
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.findAll(pageIndex, pageSize, (Fetcher<E>)null, sortedProps);
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.pager(pageIndex, pageSize).execute(this.createQuery(fetcher, sortedProps));
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Sort sort) {
        return this.findAll((Pageable)PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sort), null);
    }

    @Override
    public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher, Sort sort) {
        return this.findAll((Pageable)PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sort), fetcher);
    }

    @Override
    @NotNull
    public Page<E> findAll(@NotNull Pageable pageable) {
        return this.findAll(pageable, null);
    }

    @Override
    public Page<E> findAll(Pageable pageable, Fetcher<E> fetcher) {
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, this.immutableType, ExecutionPurpose.QUERY, false);
        Table table = query.getTable();
        query.orderBy(SpringOrders.toOrders((Props)table, pageable.getSort()));
        return this.pager(pageable).execute(query.select(table.fetch(fetcher)));
    }

    @Override
    public long count() {
        return this.createQuery(null, EMPTY_SORTED_PROPS).count();
    }

    @Override
    @NotNull
    public <S extends E> SimpleSaveResult<S> save(@NotNull S entity, SaveMode mode) {
        return (SimpleSaveResult)this.sqlClient.getEntities().saveCommand(entity).setMode(mode).execute();
    }

    @Override
    @NotNull
    public SimpleEntitySaveCommand<E> saveCommand(@NotNull Input<E> input) {
        return this.sqlClient.getEntities().saveCommand(input);
    }

    @Override
    @NotNull
    public <S extends E> SimpleEntitySaveCommand<S> saveCommand(@NotNull S entity) {
        return this.sqlClient.getEntities().saveCommand(entity);
    }

    @Override
    @NotNull
    public <S extends E> BatchSaveResult<S> saveAll(@NotNull Iterable<S> entities, SaveMode mode) {
        return (BatchSaveResult)this.sqlClient.getEntities().batchSaveCommand(Utils.toCollection(entities)).setMode(mode).execute();
    }

    @Override
    @NotNull
    public <S extends E> BatchEntitySaveCommand<S> saveAllCommand(@NotNull Iterable<S> entities) {
        return this.sqlClient.getEntities().batchSaveCommand(Utils.toCollection(entities));
    }

    @Override
    public int delete(@NotNull E entity, DeleteMode mode) {
        return this.sqlClient.getEntities().delete(this.entityType, ImmutableObjects.get(entity, (PropId)this.immutableType.getIdProp().getId()), mode).getAffectedRowCount((AffectedTable)AffectedTable.of((ImmutableType)this.immutableType));
    }

    @Override
    public int deleteAll(@NotNull Iterable<? extends E> entities, DeleteMode mode) {
        return this.sqlClient.getEntities().batchDelete(this.entityType, (Collection)Utils.toCollection(entities).stream().map(it -> ImmutableObjects.get((Object)it, (PropId)this.immutableType.getIdProp().getId())).collect(Collectors.toList()), mode).getAffectedRowCount((AffectedTable)AffectedTable.of((ImmutableType)this.immutableType));
    }

    @Override
    public int deleteById(@NotNull ID id, DeleteMode mode) {
        return this.sqlClient.getEntities().delete(this.entityType, id, mode).getAffectedRowCount((AffectedTable)AffectedTable.of((ImmutableType)this.immutableType));
    }

    @Override
    public int deleteByIds(Iterable<? extends ID> ids, DeleteMode mode) {
        return this.sqlClient.getEntities().batchDelete(this.entityType, Utils.toCollection(ids), mode).getAffectedRowCount((AffectedTable)AffectedTable.of((ImmutableType)this.immutableType));
    }

    @Override
    public void deleteAll() {
        Mutations.createDelete((JSqlClientImplementor)this.sqlClient, (ImmutableType)this.immutableType, (d, t) -> d.enableDissociation()).execute();
    }

    private ConfigurableRootQuery<?, E> createQuery(Fetcher<E> fetcher, TypedProp.Scalar<?, ?>[] sortedProps) {
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, this.immutableType, ExecutionPurpose.QUERY, false);
        Table table = query.getTable();
        for (TypedProp.Scalar<?, ?> sortedProp : sortedProps) {
            if (!sortedProp.unwrap().getDeclaringType().isAssignableFrom(this.immutableType)) {
                throw new IllegalArgumentException("The sorted field \"" + sortedProp + "\" does not belong to the type \"" + this.immutableType + "\" or its super types");
            }
            PropExpression expr = (PropExpression)table.get(sortedProp.unwrap().getName());
            Order astOrder = sortedProp.isDesc() ? expr.desc() : expr.asc();
            if (sortedProp.isNullsFirst()) {
                astOrder = astOrder.nullsFirst();
            }
            if (sortedProp.isNullsLast()) {
                astOrder = astOrder.nullsLast();
            }
            query.orderBy(new Order[]{astOrder});
        }
        query.freeze();
        return query.select((Selection)(fetcher != null ? table.fetch(fetcher) : table));
    }

    private static class PagerImpl
    implements JRepository.Pager {
        private final int pageIndex;
        private final int pageSize;

        PagerImpl(int pageIndex, int pageSize) {
            this.pageIndex = pageIndex;
            this.pageSize = pageSize;
        }

        @Override
        public <T> Page<T> execute(ConfigurableRootQuery<?, T> query) {
            return (Page)PagingQueries.execute(query, (int)this.pageIndex, (int)this.pageSize, (entities, totalCount, queryImplementor) -> new PageImpl(entities, (Pageable)PageRequest.of((int)this.pageIndex, (int)this.pageSize, (Sort)Utils.toSort(queryImplementor.getOrders(), queryImplementor.getSqlClient().getMetadataStrategy())), (long)totalCount));
        }
    }
}

