/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.babyfish.jimmer.spring.cache.impl.TransactionCacheOperatorFlusher;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.TransactionCacheOperator;
import org.babyfish.jimmer.sql.kt.KSqlClient;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@Configuration
public class TransactionCacheOperatorFlusherConfig {
    @Bean
    public TransactionCacheOperatorFlusher transactionCacheOperatorFlusher(List<JSqlClient> jSqlClients, List<KSqlClient> kSqlClients) {
        CacheOperator op;
        LinkedHashSet<TransactionCacheOperator> transactionCacheOperators = new LinkedHashSet<TransactionCacheOperator>();
        for (JSqlClient jSqlClient : jSqlClients) {
            op = ((JSqlClientImplementor)jSqlClient).getCacheOperator();
            if (!(op instanceof TransactionCacheOperator)) continue;
            transactionCacheOperators.add((TransactionCacheOperator)op);
        }
        for (KSqlClient kSqlClient : kSqlClients) {
            op = kSqlClient.getJavaClient().getCacheOperator();
            if (!(op instanceof TransactionCacheOperator)) continue;
            transactionCacheOperators.add((TransactionCacheOperator)op);
        }
        if (transactionCacheOperators.isEmpty()) {
            return null;
        }
        return new TransactionCacheOperatorFlusher(new ArrayList<TransactionCacheOperator>(transactionCacheOperators));
    }
}

