/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cloud;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.swagger.v3.oas.annotations.Hidden;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.compiler.FetcherCompiler;
import org.babyfish.jimmer.sql.runtime.MicroServiceExporter;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Hidden
@ApiIgnore
@RestController
@Transactional(readOnly=true)
public class MicroServiceExporterController {
    public static final String BY_IDS = "/jimmerMicroServiceBridge/byIds";
    public static final String BY_ASSOCIATED_IDS = "/jimmerMicroServiceBridge/byAssociatedIds";
    public static final String IDS = "ids";
    public static final String PROP = "prop";
    public static final String TARGET_IDS = "targetIds";
    public static final String FETCHER = "fetcher";
    private final MicroServiceExporter exporter;
    private final ObjectMapper mapper;

    public MicroServiceExporterController(JSqlClient sqlClient, ObjectMapper mapper) {
        this.exporter = new MicroServiceExporter(sqlClient);
        this.mapper = mapper;
    }

    @GetMapping(value={"/jimmerMicroServiceBridge/byIds"}, produces={"application/json"})
    public List<ImmutableSpi> findByIds(@RequestParam(value="ids") String idArrStr, @RequestParam(value="fetcher") String fetcherStr) throws JsonProcessingException, IOException {
        Fetcher fetcher = FetcherCompiler.compile((String)fetcherStr);
        Class idType = fetcher.getImmutableType().getIdProp().getElementClass();
        List ids = (List)this.mapper.readValue(idArrStr, (JavaType)CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe((Class)Classes.boxTypeOf((Class)idType))));
        return this.exporter.findByIds((Collection)ids, fetcher);
    }

    @GetMapping(value={"/jimmerMicroServiceBridge/byAssociatedIds"}, produces={"application/json"})
    public List<Tuple2<Object, ImmutableSpi>> findByAssociatedIds(@RequestParam(value="prop") String prop, @RequestParam(value="targetIds") String targetIdArrStr, @RequestParam(value="fetcher") String fetcherStr, HttpServletResponse response) throws Exception {
        Fetcher fetcher = FetcherCompiler.compile((String)fetcherStr);
        ImmutableProp immutableProp = fetcher.getImmutableType().getProp(prop);
        Class targetIdType = immutableProp.getTargetType().getIdProp().getElementClass();
        List targetIds = (List)this.mapper.readValue(targetIdArrStr, (JavaType)CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe((Class)Classes.boxTypeOf((Class)targetIdType))));
        return this.exporter.findByAssociatedIds(immutableProp, (Collection)targetIds, fetcher);
    }
}

