/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.client;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.babyfish.jimmer.error.CodeBasedException;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.spring.cfg.JimmerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class CodeBasedExceptionAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeBasedExceptionAdvice.class);
    protected final JimmerProperties.ErrorTranslator errorTranslator;

    public CodeBasedExceptionAdvice(JimmerProperties properties) {
        this.errorTranslator = properties.getErrorTranslator();
        if (this.errorTranslator.isDebugInfoSupported()) {
            this.notice();
        }
    }

    @ExceptionHandler
    public ResponseEntity<Map<String, Object>> handle(CodeBasedException ex) {
        return new ResponseEntity(this.resultMap(ex), this.errorTranslator.getHttpStatus());
    }

    protected void notice() {
        String builder = "\n------------------------------------------------\n|                                              |\n|`jimmer.error-translator.debug-info-supported`|\n|has been turned on, this is dangerous, please |\n|make sure the current environment is          |\n|NOT PRODUCTION!                               |\n|                                              |\n------------------------------------------------\n";
        LOGGER.info(builder);
    }

    protected Map<String, Object> resultMap(CodeBasedException ex) {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("family", StringUtil.snake((String)ex.getCode().getDeclaringClass().getSimpleName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER));
        resultMap.put("code", ex.getCode().name());
        resultMap.putAll(ex.getFields());
        if (this.errorTranslator.isDebugInfoSupported()) {
            resultMap.put("debugInfo", this.debugInfoMap((Throwable)ex));
        }
        return resultMap;
    }

    protected Map<String, Object> debugInfoMap(Throwable ex) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("message", ex.getMessage());
        StackTraceElement[] elements = ex.getStackTrace();
        int size = Math.min(elements.length, this.errorTranslator.getDebugInfoMaxStackTraceCount());
        ArrayList<String> stackFrames = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            stackFrames.add(elements[i].toString());
        }
        map.put("stackFrames", stackFrames);
        if (ex.getCause() != null) {
            map.put("causeBy", this.debugInfoMap(ex.getCause()));
        }
        return map;
    }
}

