/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.client;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.babyfish.jimmer.error.CodeBasedException;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.spring.cfg.JimmerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class CodeBasedExceptionAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeBasedExceptionAdvice.class);
    private final JimmerProperties.ErrorTranslator errorTranslator;

    public CodeBasedExceptionAdvice(JimmerProperties properties) {
        this.errorTranslator = properties.getErrorTranslator();
        if (this.errorTranslator.isDebugInfoSupported()) {
            StringBuilder builder = new StringBuilder("\n");
            builder.append("------------------------------------------------\n");
            builder.append("|                                              |\n");
            builder.append("|`jimmer.error-translator.debug-info-supported`|\n");
            builder.append("|has been turned on, this is dangerous, please |\n");
            builder.append("|make sure the current environment is          |\n");
            builder.append("|NOT PRODUCTION!                               |\n");
            builder.append("|                                              |\n");
            builder.append("------------------------------------------------\n");
            LOGGER.info(builder.toString());
        }
    }

    @ExceptionHandler
    public ResponseEntity<Map<String, Object>> handle(CodeBasedException ex) {
        LinkedHashMap<String, Object> outputMap = new LinkedHashMap<String, Object>();
        outputMap.put("family", StringUtil.snake((String)ex.getCode().getDeclaringClass().getSimpleName(), (StringUtil.SnakeCase)StringUtil.SnakeCase.UPPER));
        outputMap.put("code", ex.getCode().name());
        outputMap.putAll(ex.getFields());
        if (this.errorTranslator.isDebugInfoSupported()) {
            outputMap.put("debugInfo", CodeBasedExceptionAdvice.debugInfo((Throwable)ex));
        }
        return new ResponseEntity(outputMap, this.errorTranslator.getHttpStatus());
    }

    private static Map<String, Object> debugInfo(Throwable ex) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("message", ex.getMessage());
        ArrayList<String> stackFrames = new ArrayList<String>();
        for (StackTraceElement element : ex.getStackTrace()) {
            stackFrames.add(element.toString());
        }
        map.put("stackFrames", stackFrames);
        if (ex.getCause() != null) {
            map.put("causeBy", CodeBasedExceptionAdvice.debugInfo(ex.getCause()));
        }
        return map;
    }
}

