/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.cache.RedisCaches;
import org.babyfish.jimmer.sql.cache.spi.AbstractRemoteValueBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;

public class RedisValueBinder<K, V>
extends AbstractRemoteValueBinder<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisValueBinder.class);
    private final RedisOperations<String, byte[]> operations;

    public RedisValueBinder(RedisOperations<String, byte[]> operations, ObjectMapper objectMapper, ImmutableType type, Duration duration) {
        super(objectMapper, type, null, duration, 30);
        this.operations = operations;
    }

    public RedisValueBinder(RedisConnectionFactory connectionFactory, ObjectMapper objectMapper, ImmutableType type, Duration duration) {
        super(objectMapper, type, null, duration, 30);
        this.operations = RedisCaches.cacheRedisTemplate(connectionFactory);
    }

    public RedisValueBinder(RedisOperations<String, byte[]> operations, ObjectMapper objectMapper, ImmutableProp prop, Duration duration) {
        super(objectMapper, null, prop, duration, 30);
        this.operations = operations;
    }

    public RedisValueBinder(RedisConnectionFactory connectionFactory, ObjectMapper objectMapper, ImmutableProp prop, Duration duration) {
        super(objectMapper, null, prop, duration, 30);
        this.operations = RedisCaches.cacheRedisTemplate(connectionFactory);
    }

    protected List<byte[]> read(Collection<String> keys) {
        return this.operations.opsForValue().multiGet(keys);
    }

    protected void write(final Map<String, byte[]> map) {
        this.operations.executePipelined((SessionCallback)new SessionCallback<Void>(){

            public <XK, XV> Void execute(RedisOperations<XK, XV> pops) throws DataAccessException {
                RedisOperations<XK, XV> pipelinedOps = pops;
                pipelinedOps.opsForValue().multiSet(map);
                for (String key : map.keySet()) {
                    pipelinedOps.expire((Object)key, RedisValueBinder.this.nextExpireMillis(), TimeUnit.MILLISECONDS);
                }
                return null;
            }
        });
    }

    protected void delete(Collection<String> keys) {
        LOGGER.info("Delete data from redis: {}", keys);
        this.operations.delete(keys);
    }

    protected String reason() {
        return "redis";
    }
}

