/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.babyfish.jimmer.sql.EnumType;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;

@ConstructorBinding
@ConfigurationProperties(value="jimmer")
public class JimmerProperties {
    @NotNull
    private final String language;
    @NotNull
    private final Dialect dialect;
    @NotNull
    private final boolean showSql;
    @NotNull
    private final TriggerType triggerType;
    @NotNull
    private final EnumType.Strategy defaultEnumStrategy;
    private final int defaultBatchSize;
    private final int defaultListBatchSize;
    @NotNull
    private final Client client;
    private final Map<String, Client> clients;

    public JimmerProperties(@Nullable String language, @Nullable String dialect, boolean showSql, @Nullable TriggerType triggerType, @Nullable EnumType.Strategy defaultEnumStrategy, @Nullable Integer defaultBatchSize, @Nullable Integer defaultListBatchSize, @Nullable Client client, @Nullable Map<String, Client> clients) {
        if (language == null) {
            this.language = "java";
        } else {
            if (!language.equals("java") && !language.equals("kotlin")) {
                throw new IllegalArgumentException("`jimmer.language` must be \"java\" or \"kotlin\"");
            }
            this.language = language;
        }
        if (dialect == null) {
            this.dialect = new DefaultDialect();
        } else {
            Class<?> clazz;
            try {
                clazz = Class.forName(dialect, true, Dialect.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("The class \"" + dialect + "\" specified by `jimmer.language` cannot be found");
            }
            if (!Dialect.class.isAssignableFrom(clazz) || clazz.isInterface()) {
                throw new IllegalArgumentException("The class \"" + dialect + "\" specified by `jimmer.language` must be a valid dialect implementation");
            }
            try {
                this.dialect = (Dialect)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalArgumentException("Create create instance for the class \"" + dialect + "\" specified by `jimmer.language`", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Create create instance for the class \"" + dialect + "\" specified by `jimmer.language`", ex);
            }
        }
        this.showSql = showSql;
        this.triggerType = triggerType != null ? triggerType : TriggerType.BINLOG_ONLY;
        this.defaultEnumStrategy = defaultEnumStrategy != null ? defaultEnumStrategy : EnumType.Strategy.NAME;
        this.defaultBatchSize = defaultBatchSize != null ? defaultBatchSize : 128;
        this.defaultListBatchSize = defaultListBatchSize != null ? defaultListBatchSize : 16;
        this.client = client == null ? new Client(null, null) : client;
        this.clients = clients;
    }

    @NotNull
    public String getLanguage() {
        return this.language;
    }

    @NotNull
    public Dialect getDialect() {
        return this.dialect;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    @NotNull
    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    @NotNull
    public EnumType.Strategy getDefaultEnumStrategy() {
        return this.defaultEnumStrategy;
    }

    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public int getDefaultListBatchSize() {
        return this.defaultListBatchSize;
    }

    @NotNull
    public Client getClient() {
        return this.client;
    }

    public String toString() {
        return "JimmerProperties{language='" + this.language + '\'' + ", dialect=" + this.dialect + ", showSql=" + this.showSql + ", triggerType=" + this.triggerType + ", defaultBatchSize=" + this.defaultBatchSize + ", defaultListBatchSize=" + this.defaultListBatchSize + ", client=" + this.client + ", clients=" + this.clients + '}';
    }

    @ConstructorBinding
    public static class Client {
        @NotNull
        private final TypeScript ts;
        @NotNull
        private final JavaFeign javaFeign;

        public Client(@Nullable TypeScript ts, @Nullable JavaFeign javaFeign) {
            this.ts = ts == null ? new TypeScript(null, "Api", 4, false) : ts;
            this.javaFeign = javaFeign == null ? new JavaFeign(null, "", 4, "") : javaFeign;
        }

        @NotNull
        public TypeScript getTs() {
            return this.ts;
        }

        @NotNull
        public JavaFeign getJavaFeign() {
            return this.javaFeign;
        }

        public String toString() {
            return "Client{ts=" + this.ts + ", javaFeign=" + this.javaFeign + '}';
        }

        @ConstructorBinding
        public static class TypeScript {
            @Nullable
            private final String path;
            @NotNull
            private final String apiName;
            private final int indent;
            private final boolean anonymous;

            public TypeScript(@Nullable String path, @Nullable String apiName, int indent, boolean anonymous) {
                if (path == null || path.isEmpty()) {
                    this.path = null;
                } else {
                    if (!path.startsWith("/")) {
                        throw new IllegalArgumentException("`jimmer.client.ts.path` must start with \"/\"");
                    }
                    this.path = path;
                }
                this.apiName = apiName == null || apiName.isEmpty() ? "Api" : apiName;
                this.indent = indent != 0 ? Math.max(indent, 2) : 4;
                this.anonymous = anonymous;
            }

            @Nullable
            public String getPath() {
                return this.path;
            }

            @NotNull
            public String getApiName() {
                return this.apiName;
            }

            public int getIndent() {
                return this.indent;
            }

            public boolean isAnonymous() {
                return this.anonymous;
            }

            public String toString() {
                return "TypeScript{path='" + this.path + '\'' + ", anonymous=" + this.anonymous + '}';
            }
        }

        @ConstructorBinding
        public static class JavaFeign {
            @Nullable
            private final String path;
            @NotNull
            private final String apiName;
            private final int indent;
            private final String basePackage;

            public JavaFeign(@Nullable String path, @Nullable String apiName, int indent, @Nullable String basePackage) {
                if (path == null || path.isEmpty()) {
                    this.path = null;
                } else {
                    if (!path.startsWith("/")) {
                        throw new IllegalArgumentException("`jimmer.client.ts.path` must start with \"/\"");
                    }
                    this.path = path;
                }
                this.apiName = apiName == null || apiName.isEmpty() ? "Api" : apiName;
                this.indent = indent != 0 ? Math.max(indent, 2) : 4;
                this.basePackage = basePackage == null || basePackage.isEmpty() ? "" : basePackage;
            }

            @Nullable
            public String getPath() {
                return this.path;
            }

            @NotNull
            public String getApiName() {
                return this.apiName;
            }

            public int getIndent() {
                return this.indent;
            }

            public String getBasePackage() {
                return this.basePackage;
            }

            public String toString() {
                return "JavaFeign{path='" + this.path + '\'' + ", clientName='" + this.apiName + '\'' + ", indent=" + this.indent + ", basePackage=" + this.basePackage + '}';
            }
        }
    }
}

