/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.parser;

import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.repository.parser.Context;
import org.babyfish.jimmer.spring.repository.parser.Path;
import org.babyfish.jimmer.spring.repository.parser.Predicate;
import org.babyfish.jimmer.spring.repository.parser.PropPredicateParser;
import org.babyfish.jimmer.spring.repository.parser.QueryMethodParser;
import org.babyfish.jimmer.spring.repository.parser.Source;
import org.babyfish.jimmer.sql.ast.LikeMode;

public abstract class PropPredicate
implements Predicate {
    protected final Path path;
    protected final Op op;
    protected final boolean insensitive;
    protected final LikeMode likeMode;

    public static PropPredicate of(Context ctx, boolean allowCollection, boolean allIgnoreCase, Source source, ImmutableType type) {
        return new PropPredicateParser(ctx, allowCollection, allIgnoreCase).parse(source, type);
    }

    public PropPredicate(Path path, Op op, boolean insensitive, LikeMode likeMode) {
        this.path = path;
        this.op = op;
        this.insensitive = insensitive;
        this.likeMode = likeMode;
    }

    public Path getPath() {
        return this.path;
    }

    public Op getOp() {
        return this.op;
    }

    public boolean isInsensitive() {
        return this.insensitive;
    }

    public LikeMode getLikeMode() {
        return this.likeMode;
    }

    public abstract int getParamIndex();

    public abstract int getLogicParamIndex();

    public abstract int getParamIndex2();

    public abstract int getLogicParamIndex2();

    public static enum Op {
        TRUE("IsTrue"),
        FALSE("IsFalse"),
        EQ("Equals"),
        NE("NotEqual"),
        LT("LessThan"),
        LE("LessThanEqual"),
        GT("GreaterThan"),
        GE("GreaterThanEqual"),
        NULL("IsNull"),
        NOT_NULL("IsNot"),
        IN("In"),
        NOT_IN("NotIn"),
        BETWEEN("Between"),
        NOT_BETWEEN("NotBetween"),
        LIKE("Like"),
        NOT_LIKE("NotLike");

        private final String text;

        private Op(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    static class Resolved
    extends PropPredicate {
        private final int paramIndex;
        private final int logicParamIndex;
        private final int paramIndex2;
        private final int logicParamIndex2;

        public Resolved(Path path, Op op, boolean insensitive, LikeMode likeMode, int paramIndex, int logicParamIndex, int paramIndex2, int logicParamIndex2) {
            super(path, op, insensitive, likeMode);
            this.paramIndex = paramIndex;
            this.logicParamIndex = logicParamIndex;
            this.paramIndex2 = paramIndex2;
            this.logicParamIndex2 = logicParamIndex2;
        }

        @Override
        public int getParamIndex() {
            return this.paramIndex;
        }

        @Override
        public int getLogicParamIndex() {
            return this.logicParamIndex;
        }

        @Override
        public int getParamIndex2() {
            return this.paramIndex2;
        }

        @Override
        public int getLogicParamIndex2() {
            return this.logicParamIndex2;
        }

        public String toString() {
            return "ResolvedPredicate{path=" + this.path + ", op=" + (Object)((Object)this.op) + ", insensitive=" + this.insensitive + ", likeMode=" + this.likeMode + ", paramIndex=" + this.paramIndex + ", logicParamIndex=" + this.logicParamIndex + ", paramIndex2=" + this.paramIndex2 + ", logicParamIndex2=" + this.logicParamIndex2 + '}';
        }
    }

    static class Unresolved
    extends PropPredicate {
        public Unresolved(Path path, Op op, boolean insensitive, LikeMode likeMode) {
            super(path, op, insensitive, likeMode);
        }

        @Override
        public int getParamIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLogicParamIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getParamIndex2() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLogicParamIndex2() {
            throw new UnsupportedOperationException();
        }

        Resolved resolve() {
            return new Resolved(this.path, this.op, this.insensitive, this.likeMode, -1, -1, -1, -1);
        }

        Resolved resolve(QueryMethodParser.Param param) {
            return new Resolved(this.path, this.op, this.insensitive, this.likeMode, param.getIndex(), param.getLogicIndex(), -1, -1);
        }

        Resolved resolve(QueryMethodParser.Param param, QueryMethodParser.Param param2) {
            return new Resolved(this.path, this.op, this.insensitive, this.likeMode, param.getIndex(), param.getLogicIndex(), param2.getIndex(), param2.getLogicIndex());
        }

        public String toString() {
            return "UnresolvedPredicate{path=" + this.path + ", op=" + (Object)((Object)this.op) + ", insensitive=" + this.insensitive + ", likeMode=" + this.likeMode + '}';
        }
    }
}

