/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository;

import java.util.ArrayList;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.springframework.data.domain.Sort;

public class SpringOrders {
    private static final TypedProp.Scalar<?, ?>[] EMPTY_PROPS = new TypedProp.Scalar[0];
    private static final Order[] EMPTY_ORDERS = new Order[0];

    private SpringOrders() {
    }

    public static Order[] toOrders(Props table, Sort sort) {
        if (sort == null || sort.isEmpty()) {
            return EMPTY_ORDERS;
        }
        ArrayList<Order> astOrders = new ArrayList<Order>();
        for (Sort.Order order : sort) {
            Expression expr = Order.orderedExpression((Props)table, (String)order.getProperty());
            Order astOrder = order.isDescending() ? expr.desc() : expr.asc();
            switch (order.getNullHandling()) {
                case NULLS_FIRST: {
                    astOrder = astOrder.nullsFirst();
                    break;
                }
                case NULLS_LAST: {
                    astOrder = astOrder.nullsLast();
                }
            }
            astOrders.add(astOrder);
        }
        return astOrders.toArray(EMPTY_ORDERS);
    }

    public static TypedProp.Scalar<?, ?>[] toTypedProps(Class<?> type, Sort sort) {
        ImmutableType immutableType = ImmutableType.get(type);
        ArrayList<TypedProp.Scalar> props = new ArrayList<TypedProp.Scalar>();
        for (Sort.Order order : sort) {
            if (order.getProperty().contains(".")) {
                throw new IllegalArgumentException("The property \"" + order.getProperty() + "\", `Sorts.toTypedProps()` does not support property chain name contains '.'");
            }
            TypedProp.Scalar prop = TypedProp.scalar((ImmutableProp)immutableType.getProp(order.getProperty()));
            props.add(order.isDescending() ? prop.desc() : prop);
        }
        return props.toArray(EMPTY_PROPS);
    }
}

