/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.client;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.babyfish.jimmer.client.generator.ts.TypeScriptGenerator;
import org.babyfish.jimmer.client.meta.Metadata;
import org.babyfish.jimmer.spring.cfg.JimmerProperties;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TypeScriptController {
    private final Metadata metadata;
    private final JimmerProperties properties;

    public TypeScriptController(Metadata metadata, JimmerProperties properties) {
        this.metadata = metadata;
        this.properties = properties;
    }

    @GetMapping(value={"${jimmer.client.ts.path}"})
    public void download(@RequestParam(name="apiName", required=false) String apiName, @RequestParam(name="indent", defaultValue="0") int indent, @RequestParam(name="anonymous", required=false) Boolean anonymous, HttpServletResponse response) throws IOException {
        JimmerProperties.Client.TypeScript ts = this.properties.getClient().getTs();
        response.setContentType("application/zip");
        try (ServletOutputStream out = response.getOutputStream();){
            new TypeScriptGenerator(apiName != null && !apiName.isEmpty() ? apiName : ts.getApiName(), indent != 0 ? indent : ts.getIndent(), anonymous != null ? anonymous.booleanValue() : ts.isAnonymous()).generate(this.metadata, (OutputStream)out);
        }
    }
}

