/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.parser;

import java.lang.reflect.Method;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.repository.parser.Context;
import org.babyfish.jimmer.spring.repository.parser.Query;
import org.babyfish.jimmer.spring.repository.parser.QueryMethodParser;

public class QueryMethod {
    private final Method javaMethod;
    private final Query query;
    private final Class<?> staticType;
    private final int pageableParamIndex;
    private final int sortParamIndex;
    private final int fetcherParamIndex;
    private final int staticTypeParamIndex;

    public QueryMethod(Method javaMethod, Query query, Class<?> staticType, int pageableParamIndex, int sortParamIndex, int fetcherParamIndex, int staticTypeParamIndex) {
        this.javaMethod = javaMethod;
        this.query = query;
        this.staticType = staticType;
        this.pageableParamIndex = pageableParamIndex;
        this.sortParamIndex = sortParamIndex;
        this.fetcherParamIndex = fetcherParamIndex;
        this.staticTypeParamIndex = staticTypeParamIndex;
    }

    public static QueryMethod of(Context ctx, ImmutableType type, Method method) {
        return QueryMethodParser.parse(ctx, type, method);
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public Query getQuery() {
        return this.query;
    }

    public Class<?> getStaticType() {
        return this.staticType;
    }

    public int getPageableParamIndex() {
        return this.pageableParamIndex;
    }

    public int getSortParamIndex() {
        return this.sortParamIndex;
    }

    public int getFetcherParamIndex() {
        return this.fetcherParamIndex;
    }

    public int getStaticTypeParamIndex() {
        return this.staticTypeParamIndex;
    }

    public String toString() {
        return "QueryMethod{javaMethod=" + this.javaMethod + ", query=" + this.query + ", staticType=" + this.staticType + ", pageableParamIndex=" + this.pageableParamIndex + ", sortParamIndex=" + this.sortParamIndex + ", fetcherParamIndex=" + this.fetcherParamIndex + ", staticTypeParamIndex=" + this.staticTypeParamIndex + '}';
    }
}

