/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.parser;

import java.util.List;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.spring.repository.parser.Context;
import org.babyfish.jimmer.spring.repository.parser.PathParser;
import org.babyfish.jimmer.spring.repository.parser.Source;

public class Path {
    private final Source source;
    private final List<ImmutableProp> props;

    public static Path of(Context ctx, boolean allowCollection, Source source, ImmutableType type) {
        return new PathParser(ctx, allowCollection).parse(source, type);
    }

    public Path(Source source, List<ImmutableProp> props) {
        this.source = source;
        this.props = props;
    }

    public Source getSource() {
        return this.source;
    }

    public List<ImmutableProp> getProps() {
        return this.props;
    }

    public boolean isScalar() {
        return this.props.get(this.props.size() - 1).isScalar(TargetLevel.ENTITY);
    }

    public Class<?> getType() {
        return this.props.get(this.props.size() - 1).getElementClass();
    }

    public String toString() {
        return this.props.stream().map(ImmutableProp::getName).collect(Collectors.joining("."));
    }
}

