/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.repository.parser.AndPredicate;
import org.babyfish.jimmer.spring.repository.parser.Context;
import org.babyfish.jimmer.spring.repository.parser.OrPredicate;
import org.babyfish.jimmer.spring.repository.parser.Path;
import org.babyfish.jimmer.spring.repository.parser.PathParser;
import org.babyfish.jimmer.spring.repository.parser.Predicate;
import org.babyfish.jimmer.spring.repository.parser.PropPredicate;
import org.babyfish.jimmer.spring.repository.parser.PropPredicateParser;
import org.babyfish.jimmer.spring.repository.parser.Query;
import org.babyfish.jimmer.spring.repository.parser.Source;
import org.babyfish.jimmer.sql.ast.query.OrderMode;

class QueryParser {
    private final Context ctx;
    private final ImmutableType type;
    private Query.Action action = Query.Action.FIND;
    private int limit = Integer.MAX_VALUE;
    private boolean distinct;
    private Path selectedPath;
    private boolean allIgnoreCase;
    private Predicate predicate;
    private final List<Query.Order> orders = new ArrayList<Query.Order>();

    QueryParser(Context ctx, ImmutableType type) {
        this.ctx = ctx;
        this.type = type;
    }

    public Query parse(Source source) {
        Source predicateSource;
        Source actionSource;
        Source orderBySource;
        Source beforeOrderByCourse;
        int orderByIndex = source.indexOf("OrderBy");
        if (orderByIndex == -1) {
            beforeOrderByCourse = source;
            orderBySource = null;
        } else {
            beforeOrderByCourse = source.subSource(0, orderByIndex);
            orderBySource = source.subSource(orderByIndex + 7);
        }
        int byIndex = beforeOrderByCourse.indexOf("By");
        if (byIndex == -1 && orderByIndex == -1) {
            throw new IllegalArgumentException("Expect `By` or `OrderBy`");
        }
        if (byIndex == -1) {
            actionSource = beforeOrderByCourse;
            predicateSource = null;
        } else {
            actionSource = beforeOrderByCourse.subSource(0, byIndex);
            predicateSource = beforeOrderByCourse.subSource(byIndex + 2);
        }
        Source selectedSource = this.parseAction(actionSource);
        if (orderByIndex > 0 && this.action != Query.Action.FIND) {
            throw new IllegalArgumentException("Illegal method name \"" + source.subSource(orderByIndex) + "\"");
        }
        if (!selectedSource.isEmpty()) {
            if (this.action != Query.Action.FIND) {
                throw new IllegalArgumentException("Illegal method name \"" + selectedSource + "\"");
            }
            List<Source> selectedSources = this.parseLimit(selectedSource);
            if ((selectedSource = this.parseDistinct(selectedSources)) != null) {
                this.selectedPath = new PathParser(this.ctx, this.distinct).parse(selectedSource, this.type);
            }
        }
        if (predicateSource != null) {
            this.parsePredicates(predicateSource);
        }
        if (orderBySource != null) {
            this.parseOrders(orderBySource);
        }
        return new Query(this.action, this.limit, this.distinct, this.selectedPath, this.predicate, Collections.unmodifiableList(this.orders));
    }

    private Source parseAction(Source source) {
        Source restSource = source.trimStart("find", "findAll", "read", "get", "query", "search");
        if (restSource != null) {
            return restSource;
        }
        restSource = source.trimStart("stream");
        if (restSource != null) {
            throw new IllegalArgumentException("method prefix \"stream\" is not supported temporarily");
        }
        restSource = source.trimStart("exists");
        if (restSource != null) {
            this.action = Query.Action.EXISTS;
            return restSource;
        }
        restSource = source.trimStart("count");
        if (restSource != null) {
            this.action = Query.Action.COUNT;
            return restSource;
        }
        restSource = source.trimStart("delete");
        if (restSource != null) {
            this.action = Query.Action.DELETE;
            return restSource;
        }
        throw new IllegalArgumentException("Illegal method prefix \"" + source + "\"");
    }

    private List<Source> parseLimit(Source source) {
        int topIndex;
        int topStartIndex = -1;
        int numStarIndex = -1;
        int firstIndex = source.indexOf("First");
        if (firstIndex != -1) {
            topStartIndex = firstIndex;
            numStarIndex = firstIndex + 5;
        }
        if (numStarIndex == -1 && (topIndex = source.indexOf("Top")) != -1) {
            topStartIndex = topIndex;
            numStarIndex = topIndex + 3;
        }
        if (numStarIndex == -1) {
            return source.isEmpty() ? Collections.emptyList() : Collections.singletonList(source);
        }
        int len = source.length();
        Source numSource = null;
        if (numStarIndex < len) {
            for (int i = numStarIndex; i < len; ++i) {
                if (Character.isDigit(source.charAt(i))) continue;
                numSource = source.subSource(numStarIndex, i);
                break;
            }
            if (numSource == null) {
                numSource = source.subSource(numStarIndex);
            }
        }
        if (numSource == null) {
            throw new IllegalArgumentException("Cannot parse limit from \"" + source + "\"");
        }
        this.limit = Integer.parseInt(numSource.asString());
        Source before = source.subSource(0, topStartIndex);
        Source after = source.subSource(numStarIndex + numSource.length());
        ArrayList<Source> restSources = new ArrayList<Source>();
        if (!before.isEmpty()) {
            restSources.add(before);
        }
        if (!after.isEmpty()) {
            restSources.add(after);
        }
        return restSources;
    }

    private Source parseDistinct(List<Source> sources) {
        if (sources.isEmpty()) {
            return null;
        }
        if (sources.size() == 1) {
            Source restSource = sources.get(0).trimStart("Distinct");
            if (restSource != null) {
                this.distinct = true;
                return restSource;
            }
            restSource = sources.get(0).trimEnd("Distinct");
            if (restSource != null) {
                this.distinct = true;
                return restSource;
            }
        }
        if (sources.size() == 2) {
            if (sources.get(0).asString().equals("Distinct")) {
                this.distinct = true;
                return sources.get(1);
            }
            if (sources.get(1).asString().equals("Distinct")) {
                this.distinct = true;
                return sources.get(0);
            }
            throw new IllegalArgumentException("Illegal method name " + sources.get(1));
        }
        return sources.get(0);
    }

    private void parsePredicates(Source source) {
        if (source.isEmpty()) {
            return;
        }
        Source restSource = source.trimEnd("AllIgnoringCase", "AllIgnoreCase");
        if (restSource != null) {
            this.allIgnoreCase = true;
            this.predicate = this.parseOrPredicate(restSource);
        } else {
            this.predicate = this.parseOrPredicate(source);
        }
    }

    private Predicate parseOrPredicate(Source source) {
        ArrayList<Source> subSources = new ArrayList<Source>();
        while (!source.isEmpty()) {
            int orIndex = source.indexOf("Or");
            if (orIndex > 0 && orIndex + 2 < source.length()) {
                subSources.add(source.subSource(0, orIndex));
                source = source.subSource(orIndex + 2);
                continue;
            }
            subSources.add(source);
            source = source.subSource(source.length());
        }
        return OrPredicate.of(subSources.stream().map(this::parseAndPredicate).collect(Collectors.toList()));
    }

    private Predicate parseAndPredicate(Source source) {
        ArrayList<Source> subSources = new ArrayList<Source>();
        while (!source.isEmpty()) {
            int andIndex = source.indexOf("And");
            if (andIndex > 0 && andIndex + 3 < source.length()) {
                subSources.add(source.subSource(0, andIndex));
                source = source.subSource(andIndex + 3);
                continue;
            }
            subSources.add(source);
            source = source.subSource(source.length());
        }
        return AndPredicate.of(subSources.stream().map(this::parsePropPredicate).collect(Collectors.toList()));
    }

    private PropPredicate parsePropPredicate(Source source) {
        if (source.isEmpty()) {
            throw new IllegalArgumentException("Cannot parse predicate from \"" + source + "\"");
        }
        return new PropPredicateParser(this.ctx, this.distinct, this.allIgnoreCase).parse(source, this.type);
    }

    private void parseOrders(Source source) {
        while (!source.isEmpty()) {
            Path path;
            Source propSource;
            int ascIndex = source.indexOf("Asc");
            int descIndex = source.indexOf("Desc");
            if (ascIndex == -1 && descIndex == -1) {
                Path path2 = new PathParser(this.ctx, this.distinct).parse(source, this.type);
                if (!path2.isScalar()) {
                    throw new IllegalArgumentException("The ordered property of \"" + source + "\" must be scalar");
                }
                this.orders.add(new Query.Order(path2, OrderMode.ASC));
                break;
            }
            if (descIndex == -1 || ascIndex > 0 && ascIndex < descIndex) {
                propSource = source.subSource(0, ascIndex);
                path = new PathParser(this.ctx, this.distinct).parse(propSource, this.type);
                if (!path.isScalar()) {
                    throw new IllegalArgumentException("The ordered property of \"" + source + "\" must be scalar");
                }
                this.orders.add(new Query.Order(path, OrderMode.ASC));
                source = source.subSource(ascIndex + 3);
                continue;
            }
            if (ascIndex != -1 && (descIndex <= 0 || descIndex >= ascIndex)) continue;
            propSource = source.subSource(0, descIndex);
            path = new PathParser(this.ctx, this.distinct).parse(propSource, this.type);
            if (!path.isScalar()) {
                throw new IllegalArgumentException("The ordered property of \"" + source + "\" must be scalar");
            }
            this.orders.add(new Query.Order(path, OrderMode.DESC));
            source = source.subSource(descIndex + 4);
        }
    }
}

