/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg;

import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.spring.cfg.JimmerProperties;
import org.babyfish.jimmer.spring.cfg.SqlClientConfig;
import org.babyfish.jimmer.spring.client.TypeScriptController;
import org.babyfish.jimmer.spring.repository.config.JimmerRepositoriesRegistrar;
import org.babyfish.jimmer.spring.repository.config.JimmerRepositoryConfigExtension;
import org.babyfish.jimmer.spring.repository.support.JimmerRepositoryFactoryBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@AutoConfiguration(after={DataSourceAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.data.jimmer.repositories", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingBean(value={JimmerRepositoryFactoryBean.class, JimmerRepositoryConfigExtension.class})
@EnableConfigurationProperties(value={JimmerProperties.class})
@Import(value={SqlClientConfig.class})
public class JimmerAutoConfiguration {
    @ConditionalOnMissingBean(value={ImmutableModule.class})
    @Bean
    public ImmutableModule immutableModule() {
        return new ImmutableModule();
    }

    @ConditionalOnProperty(value={"jimmer.client.ts.path"})
    @ConditionalOnMissingBean(value={TypeScriptController.class})
    @Bean
    public TypeScriptController typeScriptService(ApplicationContext ctx, JimmerProperties properties) {
        return new TypeScriptController(ctx, properties);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={JimmerRepositoryConfigExtension.class})
    @Import(value={JimmerRepositoriesRegistrar.class})
    static class JimmerRepositoriesConfiguration {
        JimmerRepositoriesConfiguration() {
        }
    }
}

