/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.bytecode;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import kotlin.reflect.KClass;
import org.babyfish.jimmer.impl.asm.MethodVisitor;
import org.babyfish.jimmer.impl.asm.Type;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.repository.bytecode.ClassCodeWriter;
import org.babyfish.jimmer.spring.repository.bytecode.Constants;
import org.babyfish.jimmer.spring.repository.parser.AndPredicate;
import org.babyfish.jimmer.spring.repository.parser.OrPredicate;
import org.babyfish.jimmer.spring.repository.parser.Predicate;
import org.babyfish.jimmer.spring.repository.parser.PropPredicate;
import org.babyfish.jimmer.spring.repository.parser.QueryMethod;

public abstract class MethodCodeWriter
implements Constants {
    protected final ClassCodeWriter parent;
    protected final Method method;
    protected final String id;
    protected MethodVisitor mv;
    private Method defaultImplMethod;
    private boolean defaultImplMethodCreated;

    protected MethodCodeWriter(ClassCodeWriter parent, Method method, String id) {
        this.parent = parent;
        this.method = method;
        this.id = id;
    }

    public void write() {
        if (this.method.isDefault()) {
            return;
        }
        QueryMethod queryMethod = QueryMethod.of(this.parent.ctx, ImmutableType.get((Class)this.parent.metadata.getDomainType()), this.method);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int slot = 0;
        for (Class<?> type : this.method.getParameterTypes()) {
            slots.add(++slot);
            if (type != Long.TYPE && type != Double.TYPE) continue;
            ++slot;
        }
        this.mv = this.parent.getClassVisitor().visitMethod(1, this.method.getName(), Type.getMethodDescriptor((Method)this.method), null, null);
        this.mv.visitCode();
        this.writeCode(queryMethod, slots);
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    private void writeCode(QueryMethod queryMethod, List<Integer> slots) {
        this.visitLoadJSqlClient();
        this.mv.visitLdcInsn((Object)Type.getType((Class)this.parent.metadata.getDomainType()));
        this.mv.visitMethodInsn(184, IMMUTABLE_TYPE_INTERNAL_NAME, "get", "(Ljava/lang/Class;)" + IMMUTABLE_TYPE_DESCRIPTOR, true);
        this.mv.visitFieldInsn(178, this.parent.getImplInternalName(), this.queryMethodFieldName(), QUERY_METHOD_DESCRIPTOR);
        if (queryMethod.getPageableParamIndex() != -1) {
            this.mv.visitVarInsn(25, slots.get(queryMethod.getPageableParamIndex()).intValue());
        } else {
            this.mv.visitInsn(1);
        }
        if (queryMethod.getSortParamIndex() != -1) {
            this.mv.visitVarInsn(25, slots.get(queryMethod.getSortParamIndex()).intValue());
        } else {
            this.mv.visitInsn(1);
        }
        if (queryMethod.getFetcherParamIndex() != -1) {
            this.mv.visitVarInsn(25, slots.get(queryMethod.getFetcherParamIndex()).intValue());
        } else {
            this.mv.visitInsn(1);
        }
        if (queryMethod.getStaticTypeParamIndex() != -1) {
            this.mv.visitVarInsn(25, slots.get(queryMethod.getStaticTypeParamIndex()).intValue());
            if (this.method.getParameterTypes()[queryMethod.getStaticTypeParamIndex()] == KClass.class) {
                this.mv.visitMethodInsn(184, "kotlin/jvm/JvmClassMappingKt", "getJavaClass", "(Lkotlin/reflect/KClass;)Ljava/lang/Class;", false);
            }
        } else if (queryMethod.getStaticType() != null) {
            this.mv.visitLdcInsn((Object)Type.getType(queryMethod.getStaticType()));
        } else {
            this.mv.visitInsn(1);
        }
        ArrayList<PropPredicate> ps = new ArrayList<PropPredicate>();
        MethodCodeWriter.collectPropPredicate(queryMethod.getQuery().getPredicate(), ps);
        this.mv.visitLdcInsn((Object)MethodCodeWriter.argCount(ps));
        this.mv.visitTypeInsn(189, "java/lang/Object");
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        for (PropPredicate p : ps) {
            if (p.getLogicParamIndex() != -1) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn((Object)p.getLogicParamIndex());
                this.visitLoad(parameterTypes[p.getParamIndex()], slots.get(p.getParamIndex()));
                this.visitBox(parameterTypes[p.getParamIndex()]);
                this.mv.visitInsn(83);
            }
            if (p.getLogicParamIndex2() == -1) continue;
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn((Object)p.getLogicParamIndex2());
            this.visitLoad(parameterTypes[p.getParamIndex2()], slots.get(p.getParamIndex2()));
            this.visitBox(parameterTypes[p.getParamIndex2()]);
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(184, QUERY_EXECUTORS_INTERNAL_NAME, "execute", QUERY_EXECUTORS_METHOD_DESCRIPTOR, false);
        this.visitUnbox(this.method.getReturnType());
        if (this.method.getReturnType() == Void.TYPE) {
            this.mv.visitInsn(87);
        }
        this.visitReturn(this.method.getReturnType());
    }

    private static void collectPropPredicate(Predicate predicate, List<PropPredicate> propPredicates) {
        block3: {
            block4: {
                block2: {
                    if (!(predicate instanceof PropPredicate)) break block2;
                    propPredicates.add((PropPredicate)predicate);
                    break block3;
                }
                if (!(predicate instanceof AndPredicate)) break block4;
                for (Predicate subPredicate : ((AndPredicate)predicate).getPredicates()) {
                    MethodCodeWriter.collectPropPredicate(subPredicate, propPredicates);
                }
                break block3;
            }
            if (!(predicate instanceof OrPredicate)) break block3;
            for (Predicate subPredicate : ((OrPredicate)predicate).getPredicates()) {
                MethodCodeWriter.collectPropPredicate(subPredicate, propPredicates);
            }
        }
    }

    private static int argCount(List<PropPredicate> propPredicates) {
        int count2 = 0;
        for (PropPredicate p : propPredicates) {
            if (p.getLogicParamIndex() != -1) {
                ++count2;
            }
            if (p.getLogicParamIndex2() == -1) continue;
            ++count2;
        }
        return count2;
    }

    protected abstract void visitLoadJSqlClient();

    public MethodVisitor getMethodVisitor() {
        return this.mv;
    }

    String queryMethodFieldName() {
        return "QUERY_METHOD_{" + this.id + '}';
    }

    protected final Method getDefaultImplMethod() {
        if (this.defaultImplMethodCreated) {
            return this.defaultImplMethod;
        }
        this.defaultImplMethod = this.onGetDefaultImplMethod();
        this.defaultImplMethodCreated = true;
        return this.defaultImplMethod;
    }

    protected Method onGetDefaultImplMethod() {
        return null;
    }

    protected void visitReturn(Class<?> type) {
        if (type == Void.TYPE) {
            this.mv.visitInsn(177);
        } else if (type == Boolean.TYPE) {
            this.mv.visitInsn(172);
        } else if (type == Character.TYPE) {
            this.mv.visitInsn(172);
        } else if (type == Byte.TYPE) {
            this.mv.visitInsn(172);
        } else if (type == Short.TYPE) {
            this.mv.visitInsn(172);
        } else if (type == Integer.TYPE) {
            this.mv.visitInsn(172);
        } else if (type == Long.TYPE) {
            this.mv.visitInsn(173);
        } else if (type == Float.TYPE) {
            this.mv.visitInsn(174);
        } else if (type == Double.TYPE) {
            this.mv.visitInsn(175);
        } else {
            this.mv.visitInsn(176);
        }
    }

    private int visitLoad(Class<?> type, int slot) {
        if (type == Boolean.TYPE) {
            this.mv.visitVarInsn(21, slot);
            return 1;
        }
        if (type == Character.TYPE) {
            this.mv.visitVarInsn(21, slot);
            return 1;
        }
        if (type == Byte.TYPE) {
            this.mv.visitVarInsn(21, slot);
            return 1;
        }
        if (type == Short.TYPE) {
            this.mv.visitVarInsn(21, slot);
            return 1;
        }
        if (type == Integer.TYPE) {
            this.mv.visitVarInsn(21, slot);
            return 1;
        }
        if (type == Long.TYPE) {
            this.mv.visitVarInsn(22, slot);
            return 2;
        }
        if (type == Float.TYPE) {
            this.mv.visitVarInsn(23, slot);
            return 1;
        }
        if (type == Double.TYPE) {
            this.mv.visitVarInsn(24, slot);
            return 2;
        }
        this.mv.visitVarInsn(25, slot);
        return 1;
    }

    private void visitBox(Class<?> type) {
        if (type == Boolean.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        } else if (type == Character.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
        } else if (type == Byte.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
        } else if (type == Short.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
        } else if (type == Integer.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else if (type == Long.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
        } else if (type == Float.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
        } else if (type == Double.TYPE) {
            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
        }
    }

    private void visitUnbox(Class<?> type) {
        if (type == Boolean.TYPE) {
            this.mv.visitTypeInsn(192, "java/lang/Boolean");
            this.mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
        } else if (type == Character.TYPE) {
            this.mv.visitTypeInsn(192, "java/lang/Character");
            this.mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
        } else if (type == Byte.TYPE) {
            this.mv.visitTypeInsn(192, "java/lang/Byte");
            this.mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
        } else if (type == Short.TYPE) {
            this.mv.visitTypeInsn(192, "java/lang/Short");
            this.mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
        } else if (type == Integer.TYPE) {
            this.mv.visitTypeInsn(192, "java/lang/Integer");
            this.mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
        } else if (type == Long.TYPE) {
            this.mv.visitTypeInsn(192, "java/lang/Long");
            this.mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
        } else if (type == Float.TYPE) {
            this.mv.visitTypeInsn(192, "java/lang/Float");
            this.mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
        } else if (type == Double.TYPE) {
            this.mv.visitTypeInsn(192, "java/lang/Double");
            this.mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
        } else {
            this.mv.visitTypeInsn(192, Type.getInternalName(type));
        }
    }

    protected class VarLoader {
        private int slot;

        public VarLoader(int slot) {
            this.slot = slot;
        }

        public void load(Class<?> type) {
            this.slot += MethodCodeWriter.this.visitLoad(type, this.slot);
        }
    }
}

