/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.client;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.client.meta.Metadata;
import org.babyfish.jimmer.client.meta.Operation;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

public class MetadataFactoryBean
implements FactoryBean<Metadata> {
    private final ApplicationContext ctx;

    public MetadataFactoryBean(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public Class<?> getObjectType() {
        return Metadata.class;
    }

    public Metadata getObject() throws Exception {
        List packageNames = AutoConfigurationPackages.get((BeanFactory)this.ctx);
        ArrayList<Class> serviceTypes = new ArrayList<Class>();
        for (Object bean : this.ctx.getBeansWithAnnotation(RestController.class).values()) {
            boolean shouldBeParsed = false;
            for (String packageName : packageNames) {
                if (!bean.getClass().getName().startsWith(packageName + '.')) continue;
                shouldBeParsed = true;
                break;
            }
            if (!shouldBeParsed) continue;
            serviceTypes.add(AopUtils.getTargetClass(bean));
        }
        return Metadata.newBuilder().addServiceTypes(serviceTypes).setOperationParser(annotatedElement -> {
            RequestMapping requestMapping;
            if (annotatedElement instanceof Method) {
                GetMapping getMapping = annotatedElement.getAnnotation(GetMapping.class);
                if (getMapping != null) {
                    return new Tuple2((Object)MetadataFactoryBean.text(getMapping.value(), getMapping.path()), (Object)Operation.HttpMethod.GET);
                }
                PostMapping postMapping = annotatedElement.getAnnotation(PostMapping.class);
                if (postMapping != null) {
                    return new Tuple2((Object)MetadataFactoryBean.text(postMapping.value(), postMapping.path()), (Object)Operation.HttpMethod.POST);
                }
                PutMapping putMapping = annotatedElement.getAnnotation(PutMapping.class);
                if (putMapping != null) {
                    return new Tuple2((Object)MetadataFactoryBean.text(putMapping.value(), putMapping.path()), (Object)Operation.HttpMethod.PUT);
                }
                DeleteMapping deleteMapping = annotatedElement.getAnnotation(DeleteMapping.class);
                if (deleteMapping != null) {
                    return new Tuple2((Object)MetadataFactoryBean.text(deleteMapping.value(), deleteMapping.path()), (Object)Operation.HttpMethod.DELETE);
                }
            }
            if ((requestMapping = annotatedElement.getAnnotation(RequestMapping.class)) != null) {
                return new Tuple2((Object)MetadataFactoryBean.text(requestMapping.value(), requestMapping.path()), requestMapping.method().length != 0 ? Operation.HttpMethod.valueOf((String)requestMapping.method()[0].name()) : null);
            }
            return null;
        }).setParameterParser(new Metadata.ParameterParser(){

            @Nullable
            public Tuple2<String, Boolean> requestParamNameAndNullable(Parameter javaParameter) {
                RequestParam requestParam = javaParameter.getAnnotation(RequestParam.class);
                if (requestParam == null) {
                    return null;
                }
                return new Tuple2((Object)MetadataFactoryBean.notEmpty(requestParam.value(), requestParam.name(), javaParameter.getName()), (Object)(!requestParam.required() ? 1 : 0));
            }

            @Nullable
            public String pathVariableName(Parameter javaParameter) {
                PathVariable pathVariable = javaParameter.getAnnotation(PathVariable.class);
                if (pathVariable == null) {
                    return null;
                }
                return MetadataFactoryBean.notEmpty(pathVariable.value(), pathVariable.name(), javaParameter.getName());
            }

            public boolean isRequestBody(Parameter javaParameter) {
                return javaParameter.isAnnotationPresent(RequestBody.class);
            }
        }).build();
    }

    private static String text(String[] a, String[] b) {
        for (String value : a) {
            if (value.isEmpty()) continue;
            return value;
        }
        for (String path : b) {
            if (path.isEmpty()) continue;
            return path;
        }
        return "";
    }

    private static String notEmpty(String a, String b, String c) {
        if (!a.isEmpty()) {
            return a;
        }
        if (!b.isEmpty()) {
            return b;
        }
        return c;
    }
}

