/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.model;

import java.util.ArrayList;
import org.babyfish.jimmer.meta.TypedProp;
import org.springframework.data.domain.Sort;

public class Sorts {
    private Sorts() {
    }

    @SafeVarargs
    public static <S, T> Sort by(TypedProp.Scalar<S, T> ... props) {
        if (props == null || props.length == 0) {
            return Sort.unsorted();
        }
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>(props.length);
        for (TypedProp.Scalar<S, T> prop : props) {
            Sort.Order order = new Sort.Order(prop.isDesc() ? Sort.Direction.DESC : Sort.Direction.ASC, prop.unwrap().getName(), prop.isNullsFirst() ? Sort.NullHandling.NULLS_FIRST : (prop.isNullsLast() ? Sort.NullHandling.NULLS_LAST : Sort.NullHandling.NATIVE));
            orders.add(order);
        }
        return Sort.by(orders);
    }
}

