/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.spring.repository.support.Utils;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.annotation.AliasFor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.PagingAndSortingRepository;

@NoRepositoryBean
public interface JRepository<E, ID>
extends PagingAndSortingRepository<E, ID> {
    public JSqlClient sql();

    public Pager<E> pager(Pageable var1);

    public Pager<E> pager(int var1, int var2);

    public E findNullable(ID var1);

    public E findNullable(ID var1, Fetcher<E> var2);

    @NotNull
    default public Optional<E> findById(ID id) {
        return Optional.ofNullable(this.findNullable(id));
    }

    default public Optional<E> findById(ID id, Fetcher<E> fetcher) {
        return Optional.ofNullable(this.findNullable(id, fetcher));
    }

    @AliasFor(value="findAllById")
    public List<E> findByIds(Iterable<ID> var1);

    @AliasFor(value="findByIds")
    @NotNull
    default public Iterable<E> findAllById(@NotNull Iterable<ID> ids) {
        return this.findByIds(ids);
    }

    public List<E> findByIds(Iterable<ID> var1, Fetcher<E> var2);

    public Map<ID, E> findMapByIds(Iterable<ID> var1);

    public Map<ID, E> findMapByIds(Iterable<ID> var1, Fetcher<E> var2);

    @NotNull
    public List<E> findAll();

    public List<E> findAll(Fetcher<E> var1);

    default public List<E> findAll(TypedProp.Scalar<E, ?> sortedProp) {
        return this.findAll(new TypedProp.Scalar[]{sortedProp});
    }

    default public List<E> findAll(Fetcher<E> fetcher, TypedProp.Scalar<E, ?> sortedProp) {
        return this.findAll(fetcher, new TypedProp.Scalar[]{sortedProp});
    }

    default public List<E> findAll(TypedProp.Scalar<E, ?> sortedProp1, TypedProp.Scalar<E, ?> sortedProp2) {
        return this.findAll(new TypedProp.Scalar[]{sortedProp1, sortedProp2});
    }

    default public List<E> findAll(Fetcher<E> fetcher, TypedProp.Scalar<E, ?> sortedProp1, TypedProp.Scalar<E, ?> sortedProp2) {
        return this.findAll(fetcher, new TypedProp.Scalar[]{sortedProp1, sortedProp2});
    }

    default public List<E> findAll(TypedProp.Scalar<E, ?> sortedProp1, TypedProp.Scalar<E, ?> sortedProp2, TypedProp.Scalar<E, ?> sortedProp3) {
        return this.findAll(new TypedProp.Scalar[]{sortedProp1, sortedProp2});
    }

    default public List<E> findAll(Fetcher<E> fetcher, TypedProp.Scalar<E, ?> sortedProp1, TypedProp.Scalar<E, ?> sortedProp2, TypedProp.Scalar<E, ?> sortedProp3) {
        return this.findAll(fetcher, new TypedProp.Scalar[]{sortedProp1, sortedProp2, sortedProp3});
    }

    public List<E> findAll(TypedProp.Scalar<?, ?> ... var1);

    public List<E> findAll(Fetcher<E> var1, TypedProp.Scalar<?, ?> ... var2);

    @NotNull
    public List<E> findAll(@NotNull Sort var1);

    public List<E> findAll(Fetcher<E> var1, Sort var2);

    public Page<E> findAll(int var1, int var2);

    public Page<E> findAll(int var1, int var2, Fetcher<E> var3);

    default public Page<E> findAll(int pageIndex, int pageSize, TypedProp.Scalar<E, ?> sortedProp) {
        return this.findAll(pageIndex, pageSize, new TypedProp.Scalar[]{sortedProp});
    }

    default public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher, TypedProp.Scalar<E, ?> sortedProp) {
        return this.findAll(pageIndex, pageSize, fetcher, new TypedProp.Scalar[]{sortedProp});
    }

    default public Page<E> findAll(int pageIndex, int pageSize, TypedProp.Scalar<E, ?> sortedProp1, TypedProp.Scalar<E, ?> sortedProp2) {
        return this.findAll(pageIndex, pageSize, new TypedProp.Scalar[]{sortedProp1, sortedProp2});
    }

    default public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher, TypedProp.Scalar<E, ?> sortedProp1, TypedProp.Scalar<E, ?> sortedProp2) {
        return this.findAll(pageIndex, pageSize, fetcher, new TypedProp.Scalar[]{sortedProp1, sortedProp2});
    }

    default public Page<E> findAll(int pageIndex, int pageSize, TypedProp.Scalar<E, ?> sortedProp1, TypedProp.Scalar<E, ?> sortedProp2, TypedProp.Scalar<E, ?> sortedProp3) {
        return this.findAll(pageIndex, pageSize, new TypedProp.Scalar[]{sortedProp1, sortedProp2, sortedProp3});
    }

    default public Page<E> findAll(int pageIndex, int pageSize, Fetcher<E> fetcher, TypedProp.Scalar<E, ?> sortedProp1, TypedProp.Scalar<E, ?> sortedProp2, TypedProp.Scalar<E, ?> sortedProp3) {
        return this.findAll(pageIndex, pageSize, fetcher, new TypedProp.Scalar[]{sortedProp1, sortedProp2, sortedProp3});
    }

    public Page<E> findAll(int var1, int var2, TypedProp.Scalar<?, ?> ... var3);

    public Page<E> findAll(int var1, int var2, Fetcher<E> var3, TypedProp.Scalar<?, ?> ... var4);

    public Page<E> findAll(int var1, int var2, Sort var3);

    public Page<E> findAll(int var1, int var2, Fetcher<E> var3, Sort var4);

    @NotNull
    public Page<E> findAll(@NotNull Pageable var1);

    public Page<E> findAll(Pageable var1, Fetcher<E> var2);

    default public boolean existsById(ID id) {
        return this.findNullable(id) != null;
    }

    public long count();

    @NotNull
    default public E insert(@NotNull E entity) {
        return (E)((SimpleSaveResult)this.sql().getEntities().saveCommand(entity).configure(cfg -> {
            cfg.setMode(SaveMode.INSERT_ONLY);
            cfg.setAutoAttachingAll();
        }).execute()).getModifiedEntity();
    }

    @NotNull
    default public E update(@NotNull E entity) {
        return (E)((SimpleSaveResult)this.sql().getEntities().saveCommand(entity).configure(cfg -> {
            cfg.setMode(SaveMode.UPDATE_ONLY);
            cfg.setAutoAttachingAll();
        }).execute()).getModifiedEntity();
    }

    @NotNull
    default public <S extends E> S save(@NotNull S entity) {
        return (S)this.sql().getEntities().save(entity, true).getModifiedEntity();
    }

    @NotNull
    default public <S extends E> Iterable<S> saveAll(@NotNull Iterable<S> entities) {
        return this.sql().getEntities().batchSave(Utils.toCollection(entities), true).getSimpleResults().stream().map(SimpleSaveResult::getModifiedEntity).collect(Collectors.toList());
    }

    default public E save(Input<E> input) {
        return (E)this.sql().getEntities().save(input.toEntity(), true).getModifiedEntity();
    }

    public void delete(@NotNull E var1);

    public void deleteAll(@NotNull Iterable<? extends E> var1);

    public void deleteAll();

    public void deleteById(@NotNull ID var1);

    @AliasFor(value="deleteAllById")
    public void deleteByIds(Iterable<? extends ID> var1);

    @AliasFor(value="deleteByIds")
    default public void deleteAllById(@NotNull Iterable<? extends ID> ids) {
        this.deleteByIds(ids);
    }

    public GraphQl<E> graphql();

    public static interface GraphQl<E> {
        public <X> Map<E, X> load(TypedProp.Scalar<E, X> var1, Collection<E> var2);

        public <X> Map<E, X> load(TypedProp.Reference<E, X> var1, Collection<E> var2);

        public <X> Map<E, List<X>> load(TypedProp.ReferenceList<E, X> var1, Collection<E> var2);
    }

    public static interface Pager<E> {
        public Page<E> execute(ConfigurableRootQuery<?, E> var1);
    }
}

