/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository.bytecode;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.babyfish.jimmer.impl.asm.Type;
import org.babyfish.jimmer.spring.repository.bytecode.ClassCodeWriter;
import org.babyfish.jimmer.spring.repository.bytecode.MethodCodeWriter;

public class KotlinMethodCodeWriter
extends MethodCodeWriter {
    protected KotlinMethodCodeWriter(ClassCodeWriter parent, Method method) {
        super(parent, method);
    }

    @Override
    public void write() {
        if (this.method.isDefault()) {
            return;
        }
        Method defaultMethod = this.findDefaultMethod();
        if (defaultMethod != null) {
            this.writeDefaultInvocation(defaultMethod);
            return;
        }
        throw new IllegalStateException("The current version does not support spring-data-style abstract custom method \"" + this.method + "\", please wait for the next version. Now, you can write strongly typed DSL using java-default method.");
    }

    private void writeDefaultInvocation(Method defaultMethod) {
        this.mv = this.parent.getClassVisitor().visitMethod(1, this.method.getName(), Type.getMethodDescriptor((Method)this.method), null, null);
        this.mv.visitCode();
        MethodCodeWriter.VarLoader loader = new MethodCodeWriter.VarLoader(this.mv, 0);
        for (Class<?> type : defaultMethod.getParameterTypes()) {
            loader.load(type);
        }
        this.mv.visitMethodInsn(184, Type.getInternalName(defaultMethod.getDeclaringClass()), this.method.getName(), Type.getMethodDescriptor((Method)defaultMethod), false);
        this.visitReturn(this.method.getReturnType());
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    private Method findDefaultMethod() {
        Method defaultImplMethod;
        Class repositoryInterface = this.parent.getMetadata().getRepositoryInterface();
        Class<?> defaultImpl = null;
        for (Class<?> nestedClass : repositoryInterface.getClasses()) {
            if (!nestedClass.getSimpleName().equals("DefaultImpls")) continue;
            defaultImpl = nestedClass;
            break;
        }
        if (defaultImpl == null) {
            return null;
        }
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Class[] newParameterTypes = new Class[parameterTypes.length + 1];
        System.arraycopy(parameterTypes, 0, newParameterTypes, 1, parameterTypes.length);
        newParameterTypes[0] = repositoryInterface;
        try {
            defaultImplMethod = defaultImpl.getMethod(this.method.getName(), newParameterTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        if (Modifier.isStatic(defaultImplMethod.getModifiers())) {
            return defaultImplMethod;
        }
        return null;
    }
}

